<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

$admin = get_admin("super");

// 사용자 화면 우측과 하단을 담당하는 페이지입니다.
// 우측, 하단 화면을 꾸미려면 이 파일을 수정합니다.
?>

    </div><!-- container End -->
    <aside id="secondary" class="idx">
        <div class="aside-search aside-div">
            <form name="frmsearch1" action="<?php echo G5_SHOP_URL; ?>/search.php" onsubmit="return search_submit(this);">
                <h2>상품 검색</h2>
                <label for="sch_str" class="sound_only">상품명<strong class="sound_only"> 필수</strong></label>
                <input type="text" name="q" value="<?php echo stripslashes(get_text(get_search_string($q))); ?>" id="sch_str" required class="frm_input">
                <button type="submit" class="btn_submit"><i class="fa fa-search" aria-hidden="true"></i> 검색</button>
            </form>
        </div>
        <script>
            $(function (){
                var $hd_sch = $("#hd_sch");
                $("#hd_sch_open").click(function(){
                    $hd_sch.css("display","block");
                });
                $("#hd_sch .pop_close").click(function(){
                    $hd_sch.css("display","none");
                });
            });
            function search_submit(f) {
                if (f.q.value.length < 2) {
                    alert("검색어는 두글자 이상 입력하십시오.");
                    f.q.select();
                    f.q.focus();
                    return false;
                }
        
                return true;
            }
        </script>
        <div id="aside-popular-search" class="aside-div">
            <?php echo popular('theme/basic'); // 인기검색어, 테마의 스킨을 사용하려면 스킨을 theme/basic 과 같이 지정  ?>
        </div>
        <div id="aside-login" class="aside-div">
            <?php echo outlogin('theme/basic'); // 외부 로그인, 테마의 스킨을 사용하려면 스킨을 theme/basic 과 같이 지정 ?>
        </div>
        <div id="name" class="aside-div">
            <?php echo poll('theme/basic'); // 설문조사, 테마의 스킨을 사용하려면 스킨을 theme/basic 과 같이 지정 ?>    
        </div>
        <div class="idx-latest aside-div">
            <?php
            // 이 함수가 바로 최신글을 추출하는 역할을 합니다.
            // 사용방법 : latest(스킨, 게시판아이디, 출력라인, 글자수);
            // 테마의 스킨을 사용하려면 theme/basic 과 같이 지정
            echo latest('theme/basic', 'notice', 5, 12);
            ?>
        </div>
        
        <div class="idx-shop-menu aside-div">
        	<div class="lt">
			    <h2 class="lt_title"><strong>쇼핑몰</strong></h2>
			    <ul>
			    	<li><a href="<?php echo G5_SHOP_URL; ?>/cart.php">장바구니</a></li>
			    	<li><a href="<?php echo G5_SHOP_URL; ?>/orderinquiry.php">주문내역</a></li>
			    	<li><a href="<?php echo G5_SHOP_URL; ?>/wishlist.php">위시리스트</a></li>
				</ul>
			</div>
        </div>
    </aside>
</div><!-- wrapper End -->
    
<div id="ft">
    <div id="ft_wr">
        <div class="ft_st ft_info">
            <h2><i class="fa fa-info-circle" aria-hidden="true"></i> 사이트 정보</h2>
            <ul>
                <li><b>회사명</b> <?php echo $default['de_admin_company_name']; ?> / <b>대표</b> <?php echo $default['de_admin_company_owner']; ?></li>
                <li><b>주소</b> <?php echo $default['de_admin_company_addr']; ?></li>
                <li><b>사업자 등록번호</b> <?php echo $default['de_admin_company_saupja_no']; ?></li>
                <li><b>전화</b> <?php echo $default['de_admin_company_tel']; ?> / <b>팩스</b> <?php echo $default['de_admin_company_fax']; ?></li>
                <li><b>통신판매업신고번호</b> <?php echo $default['de_admin_tongsin_no']; ?></li>
                <li><b>개인정보관리책임자</b> <?php echo $default['de_admin_info_name']; ?></li>
            </ul>
        </div>
        <div class="ft_st ft_customer">
            <h2><i class="fa fa-user" aria-hidden="true"></i> 고객센터</h2>
            <ul>
                <li class="ft_call"><i class="fa fa-phone" aria-hidden="true"></i><a href="tel:02-1234-5678" class="f_anchor"> 02-1234-5678</a></li>
                <li><i class="fa fa-envelope" aria-hidden="true"></i><a href="mailto:abc@abc.com" class="f_anchor"> abc@abc.com</a></li>
                <li>월-금 am 11:00 - pm 05:00</li>
                <li>점심시간 : am 12:00 - pm 01:00</li>
            </ul>
        </div>
        <div class="ft_st ft_sns ft_border_none">
            <h2><i class="fa fa-star" aria-hidden="true"></i> SNS</h2>
            <ul>
                <li class="fsns fsns_f"><i class="fa fa-facebook" aria-hidden="true"></i> <a href="https://www.facebook.com/" target="_blank" class="f_anchor">페이스북</a></li>
                <li class="fsns fsns_t"><i class="fa fa-twitter" aria-hidden="true"></i> <a href="https://www.twitter.com/" target="_blank" class="f_anchor">트위터</a></li>
                <li class="fsns fsns_i"><i class="fa fa-instagram" aria-hidden="true"></i> <a href="https://instagram.com/" target="_blank" class="f_anchor">인스타그램</a></li>
                <li class="fsns fsns_u"><i class="fa fa-youtube-play" aria-hidden="true"></i> <a href="https://www.youtube.com/" target="_blank" class="f_anchor">유투브</a></li>
                <li class="fsns fsns_g"><i class="fa fa-google" aria-hidden="true"></i> <a href="https://www.google.co.kr/" target="_blank" class="f_anchor">구글</a></li>
            </ul>
        </div>
        <div class="ft_st ft_link">
            <h2><i class="fa fa-share" aria-hidden="true"></i> 바로가기</h2>
            <ul>
                <li><a href="<?php echo G5_BBS_URL; ?>/faq.php" class="f_anchor">FAQ</a></li>
                <li><a href="<?php echo G5_BBS_URL; ?>/qalist.php" class="f_anchor">1:1문의</a></li>   
                <?php
                if(G5_COMMUNITY_USE) {
                    $com_href = G5_URL;
                    $com_name = '커뮤니티';
                } else {
                    if(!preg_match('#'.G5_SHOP_DIR.'/#', $_SERVER['SCRIPT_NAME'])) {
                        $com_href = G5_SHOP_URL;
                        $com_name = '쇼핑몰'; 
                    }
                }
        
                if($com_href && $com_name) {
                ?>
                <li><a href="<?php echo $com_href; ?>/"  class="f_anchor"><?php echo $com_name; ?></a></li>
                <?php } ?>
                <li><a href="<?php echo G5_SHOP_URL; ?>/personalpay.php"  class="f_anchor">개인결제</a></li>
                <?php if(!$com_href || !$com_name) { ?>
                <li><a href="<?php echo G5_SHOP_URL; ?>/listtype.php?type=5"  class="f_anchor">세일상품</a></li>
                <?php } ?>
            </ul>
        </div>  
    </div>
    <div class="ft_copy">
        <span>Copyright &copy; 2001-2017 <?php echo $default['de_admin_company_name']; ?>. All Rights Reserved.</span>
    </div>
    <a href="#" id="ft_to_top"><i class="fa fa-lg fa-chevron-up" aria-hidden="true"></i><span class="sound_only">상단으로</span></a>
</div>

<?php
$sec = get_microtime() - $begin_time;
$file = $_SERVER['SCRIPT_NAME'];

if ($config['cf_analytics']) {
    echo $config['cf_analytics'];
}
?>

<script src="<?php echo G5_JS_URL; ?>/sns.js"></script>

<?php
include_once(G5_THEME_PATH.'/tail.sub.php');
?>
