#!/bin/bash
 
#####################################################################################
#                                                                                   #
# * APMinstaller v.0.3.3                                                            #
# * CentOS 7.6   Minimal ISO                                                        #
# * Apache 2.4.37 , MariaDB 10.3.X, PHP 7.2.X setup shell script                    #
# * Created Date    : 2019/1/3                                                      #
# * Created by  : Joo Sung ( webmaster@apachezone.com )                             #
#                                                                                   #
#####################################################################################

##########################################
#                                        #
#           repositories install         #
#                                        #
########################################## 

yum -y update
yum -y install wget openssh-clients bind-utils git nc vim-enhanced man ntsysv \
iotop sysstat strace lsof mc lrzsz zip unzip bzip2 net-tools

cd /etc/yum.repos.d && wget https://repo.codeit.guru/codeit.el`rpm -q --qf "%{VERSION}" $(rpm -q --whatprovides redhat-release)`.repo

yum install -y epel-release yum-utils

rpm -Uvh http://rpms.famillecollet.com/enterprise/remi-release-7.rpm

echo "[mariadb]" > /etc/yum.repos.d/MariaDB.repo
echo "name = MariaDB" >> /etc/yum.repos.d/MariaDB.repo
echo "baseurl = http://yum.mariadb.org/10.3/rhel7-amd64" >> /etc/yum.repos.d/MariaDB.repo
echo "gpgkey=https://yum.mariadb.org/RPM-GPG-KEY-MariaDB" >> /etc/yum.repos.d/MariaDB.repo
echo "gpgcheck=1" >> /etc/yum.repos.d/MariaDB.repo 

yum -y update

cd /root/APM

##########################################
#                                        #
#           아파치 및 HTTP2 설치             #
#                                        #
########################################## 

# Nghttp2 설치
yum --enablerepo=epel -y install libnghttp2

# /etc/mime.types 설치 
yum -y install mailcap

# httpd 설치
yum -y install c-ares

yum -y install httpd

yum -y install openldap-devel expat-devel

yum -y install libdb-devel perl

yum -y install httpd-devel mod_ssl python-certbot-apache

systemctl start httpd
systemctl enable httpd

##########################################
#                                        #
#               firewalld                #
#                                        #
##########################################  

firewall-cmd --permanent --zone=public --add-service=http
firewall-cmd --permanent --zone=public --add-service=https
firewall-cmd --permanent --zone=trusted --add-port=3306/tcp
firewall-cmd --reload

##########################################
#                                        #
#           httpd.conf   Setup           #
#                                        #
##########################################  

cp -av /etc/httpd/conf/httpd.conf /etc/httpd/conf/httpd.conf.original
sed -i 's/DirectoryIndex index.html/ DirectoryIndex index.html index.htm index.php index.php3 index.cgi index.jsp/' /etc/httpd/conf/httpd.conf
sed -i 's/Options Indexes FollowSymLinks/Options FollowSymLinks/' /etc/httpd/conf/httpd.conf
sed -i 's/#ServerName www.example.com:80/ServerName localhost:80/' /etc/httpd/conf/httpd.conf
sed -i 's/UserDir disabled/#UserDir disabled/' /etc/httpd/conf.d/userdir.conf
sed -i 's/#UserDir public_html/UserDir public_html/' /etc/httpd/conf.d/userdir.conf
sed -i 's/Options MultiViews Indexes SymLinksIfOwnerMatch IncludesNoExec/Options MultiViews SymLinksIfOwnerMatch IncludesNoExec/' /etc/httpd/conf.d/userdir.conf

cp /root/APM/index.html /var/www/html/

echo "<VirtualHost *:80>
  DocumentRoot /var/www/html
</VirtualHost> " >> /etc/httpd/conf.d/default.conf

systemctl restart httpd

##########################################
#                                        #
#         PHP7.2 및 라이브러리 install      #
#                                        #
########################################## 

yum -y --enablerepo=remi,remi-php72 install php
yum -y --enablerepo=remi,remi-php72 install php-cli php-fpm \
php-common php-devel php-gd php-imap php-json php-ldap \
php-mbstring php-mcrypt php-mysqlnd php-opcache php-soap php-xml \
php-xmlrpc php-pdo uwsgi-plugin-php php-ioncube-loader php-pecl-apcu \
php-pecl-geoip php-pecl-imagick php-pecl-memcached php-pecl-redis php-pecl-xdebug php-pecl-ssh2 \
php-pgsql php-process php-snmp php-soap phpMyAdmin


cp -av /etc/php.ini /etc/php.ini.original
sed -i 's/short_open_tag = Off/short_open_tag = On/' /etc/php.ini
sed -i 's/expose_php = On/expose_php = Off/' /etc/php.ini
sed -i 's/display_errors = Off/display_errors = On/' /etc/php.ini
sed -i 's/;error_log = php_errors.log/error_log = php_errors.log/' /etc/php.ini
sed -i 's/error_reporting = E_ALL \& ~E_DEPRECATED/error_reporting = E_ALL \& ~E_NOTICE \& ~E_DEPRECATED \& ~E_USER_DEPRECATED/' /etc/php.ini
sed -i 's/variables_order = "GPCS"/variables_order = "EGPCS"/' /etc/php.ini
sed -i 's/post_max_size = 8M/post_max_size = 100M/' /etc/php.ini
sed -i 's/upload_max_filesize = 2M/upload_max_filesize = 100M/' /etc/php.ini
sed -i 's/;date.timezone =/date.timezone = "Asia\/Seoul"/' /etc/php.ini
sed -i 's/session.gc_maxlifetime = 1440/session.gc_maxlifetime = 86400/' /etc/php.ini
sed -i 's/disable_functions =/disable_functions = system,exec,passthru,proc_open,popen,curl_multi_exec,parse_ini_file,show_source/' /etc/php.ini 
sed -i 's/cookie/http/' /etc/phpMyAdmin/config.inc.php
sed -i 's/Require local/Require all granted/' /etc/httpd/conf.d/phpMyAdmin.conf

mkdir /etc/skel/public_html
chmod 707 /etc/skel/public_html
chmod 700 /root/APM/adduser.sh

cp /root/APM/skel/index.html /etc/skel/public_html/

systemctl restart httpd

curl -sS https://getcomposer.org/installer | php -- --install-dir=/usr/local/bin/ && ln -s /usr/local/bin/composer.phar /usr/local/bin/composer
sed -i 's/allow_url_fopen = On/allow_url_fopen = Off/' /etc/php.ini

systemctl restart httpd

echo '<?php
phpinfo();
?>' >> /var/www/html/phpinfo.php

##########################################
#                                        #
#          MARIADB 10.3.X install        #
#                                        #
########################################## 

# MariaDB 10.3.x 설치
yum -y install MariaDB-server MariaDB-client

# MariaDB my.cnf 복사
#cp -av /usr/share/mysql/my-huge.cnf /etc/my.cnf.d/

systemctl enable mariadb
systemctl start mariadb

# S.M.A.R.T. 디스크 모니터링을 설치
yum -y install smartmontools

systemctl enable smartd
systemctl start smartd

rm -rf /root/APM/skel
rm -rf /root/APM/index.html

##########################################
#                                        #
#            mysql root 설정              #
#                                        #
##########################################

/usr/bin/mysql_secure_installation

##########################################
#                                        #
#           SELINUX disabled             #
#                                        #
##########################################

sed -i 's/SELINUX=enforcing/SELINUX=disabled/' /etc/selinux/config

/usr/sbin/setenforce 0

echo ""
echo ""
echo "축하 드립니다. APMinstaller 모든 작업이 끝났습니다."

exit 0

