<?php
include_once '../common.php';


//개발 또는 앱에서 접속시 크로스 도메인 허용
function header_origin()
{
    if (G5_ORIGN_TYPE == "dev") {
        //모든 접속 허용

        header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
    } else {
        //선택된 접속만 허용
        header("Access-Control-Allow-Origin: " . G5_APP_URL);
    }
    //header('Access-Control-Allow-Origin: http://localhost:3000');
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Allow-Headers: Authorization, X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, content-length");
    header('Access-Control-Max-Age: 86400');
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE, OPTIONS");
}


// 리턴값을 json으로 출력
// $result : 결과값
// $code : http 응답 코드
// $msg : 메시지
// $error_code : 에러코드
// 에러코드 기능 구분
// 00000 : 성공
// 00001 : 에러
// 00002 : 로그인 필요 - 로그인 페이지로 이동 후 로그인 후 요청 페이지로 이동
// 00003 : 권한 없음 - 메인 페이지로 이동
// 00004 : 권한 없음 - 이전 페이지로 이동
// 00005 : 본인인증 필요 - 본인인증 페이지로 이동 후 본인인증 후 요청 페이지로 이동
// 00006 : 성인인증 필요 - 성인 인증 페이지로 이동


function json_return($result, $http_code = 200, $error_code, $msg = "")
{
    global $begin_time;
    http_response_code($http_code);
    header('Content-Type: application/json');
    if ($msg) {
        $data['msg'] = $msg;
    }
    $data['data'] = $result;
    $data['code'] = $error_code;
    $end_tiem = get_microtime()- $begin_time;
    $data['time'] = $end_tiem;
    echo json_encode($data);
    exit;
}


//uuid 생성

function gen_uuid_v4() {
    $data = openssl_random_pseudo_bytes(16);
  $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
  $data[8] = chr(ord($data[8]) & 0x3f | 0x80);
  return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
 }




function set_refresh_token($token, $mb_id, $uuid, $agent)
 {
    
     $sql = "delete from g5_member_rejwt where mb_id = '$mb_id' ";
     sql_query($sql);


     $sql = "insert into 
     g5_member_rejwt 
                 set 
                     mb_id = '$mb_id',
                     uuid = '$uuid',
                     agent = '$agent',						
                     refresh_token = '$token',
                     reg_datetime = now()

             ";
     return	sql_query($sql);
 }

function get_refresh_token($uuid)
 {

     $sql = "select * from g5_member_rejwt where uuid = '$uuid'";

     return  sql_fetch($sql);
 }



 //jwt 토큰 회원 확인
 function get_jwt_member()
 {
    include_once G5_API_PATH. '/lib/jwt.php';

    $jwt = new JWT("ES256");


    //get request header Authorization value
    //$headers = getallheaders();
    //$token = $headers['Authorization'];

    $token = $_SERVER['HTTP_AUTHORIZATION'];
    if($token){
        $token = str_replace("Bearer ", "", $token);
        $algs[] = "HS256";
        $tokeninfo = $jwt->decode($token, G5_JWT_ACCESS_TOKEN_KEY,$algs);

        //아이디 암호화 salt 추가 
        $mb_id = $tokeninfo->mb_id;

        $result = get_member($mb_id);

        if ($tokeninfo->exp > time()) {

            return $result;
        } else if($token){
            //401을 반복하면 네트워크 에러로 간주해버려서 리턴을 안해버림 그래서 203을 번갈아가면서 테스트해야 함

            http_response_code('203');
           // return false;
            exit;
        }
    }else {
        return array('mb_id'=>'', 'mb_level'=> 1, 'mb_name'=> '', 'mb_point'=> 0, 'mb_certify'=>'', 'mb_email'=>'', 'mb_open'=>'', 'mb_homepage'=>'', 'mb_tel'=>'', 'mb_hp'=>'', 'mb_zip1'=>'', 'mb_zip2'=>'', 'mb_addr1'=>'', 'mb_addr2'=>'', 'mb_addr3'=>'', 'mb_addr_jibeon'=>'', 'mb_signature'=>'', 'mb_profile'=>'');
    }

     
 }

//암호화
function encrypt($data)
{
    $key = G5_JWT_CRYPT_KEY; // 고유한 키
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc')); // 초기화 벡터 생성
    $encrypted = openssl_encrypt($data, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $iv); // 데이터 암호화
    return base64_encode($iv . $encrypted); // 암호화된 데이터와 초기화 벡터를 Base64 인코딩하여 반환
}

//복호화
function decrypt($data)
{
    $key = G5_JWT_CRYPT_KEY; // 고유한 키
    $data = base64_decode($data); // Base64 디코딩
    $iv = substr($data, 0, openssl_cipher_iv_length('aes-256-cbc')); // 초기화 벡터 추출
    $encrypted = substr($data, openssl_cipher_iv_length('aes-256-cbc')); // 암호화된 데이터 추출
    return openssl_decrypt($encrypted, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $iv); // 데이터 복호화
}