<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가



// 메뉴 불러오기
function Index(){

    global $g5;
    global $config;
    global $default;
    global $member;
    global $board;
    global $is_admin;
    global $is_member;
    global $is_guest;
    global $group;
    global $write;

    $requestData = json_decode(file_get_contents('php://input'), true);

    // Get the username and password from the request data
    $bo_table = $requestData['bo_table'];


    $wr_id = $requestData['wr_id'];
    $stx = $requestData['stx'];
    $sop = $requestData['sop'];
    $sca = $requestData['sca'];
    $sst = $requestData['sst'];
    $sod = $requestData['sod'];
    $page = $requestData['page'];
    $page_rows = $requestData['page_rows'];
    

    if ($bo_table) {
        $board = get_board_db($bo_table, true);
        if (isset($board['bo_table']) && $board['bo_table']) {
            set_cookie("ck_bo_table", $board['bo_table'], 86400 * 1);
            $gr_id = $board['gr_id'];
            $write_table = $g5['write_prefix'] . $bo_table; // 게시판 테이블 전체이름
    
            if (isset($wr_id) && $wr_id) {
                $write = get_write($write_table, $wr_id);
            } else if (isset($wr_seo_title) && $wr_seo_title) {
                $write = get_content_by_field($write_table, 'bbs', 'wr_seo_title', generate_seo_title($wr_seo_title));
                if( isset($write['wr_id']) ){
                    $wr_id = $write['wr_id'];
                }
            }
        }
        
        // 게시판에서 
        if (isset($board['bo_select_editor']) && $board['bo_select_editor']){
            $config['cf_editor'] = $board['bo_select_editor'];
        }
    }


    
    if (!$board['bo_table']) {
        json_return('', 200, '00001','존재하지 않는 게시판입니다.');
     }
     
    //  check_device($board['bo_device']);
     
    //  if (isset($write['wr_is_comment']) && $write['wr_is_comment']) {
    //      goto_url(get_pretty_url($bo_table, $write['wr_parent'], '#c_'.$wr_id));
    //  }
     
     if (!$bo_table) {
         $msg = "bo_table 값이 넘어오지 않았습니다.";
         json_return('', 200, '00001',$msg);
     }
     
     $g5['board_title'] = ((G5_IS_MOBILE && $board['bo_mobile_subject']) ? $board['bo_mobile_subject'] : $board['bo_subject']);
     
     // wr_id 값이 있으면 글읽기
     if ((isset($wr_id) && $wr_id ) || (isset($wr_seo_title) && $wr_seo_title)) {
         // 글이 없을 경우 해당 게시판 목록으로 이동
         if (!isset($write['wr_id'])) {
             $msg = $wr_id .'글이 존재하지 않습니다.<br>글이 삭제되었거나 이동된 경우입니다.';
              json_return('', 200, $msg);
         }
     
         // 그룹접근 사용
         if (isset($group['gr_use_access']) && $group['gr_use_access']) {
             if ($is_guest) {
                 $msg = "비회원은 이 게시판에 접근할 권한이 없습니다.<br>회원이시라면 로그인 후 이용해 보십시오.";
                 json_return('', 200, '00001',$msg);
             }
     
             // 그룹관리자 이상이라면 통과
             if ($is_admin == "super" || $is_admin == "group") {
                 ;
             } else {
                 // 그룹접근
                 $sql = " select count(*) as cnt from {$g5['group_member_table']} where gr_id = '{$board['gr_id']}' and mb_id = '{$member['mb_id']}' ";
                 $row = sql_fetch($sql);
                 if (!$row['cnt']) {
                    json_return('', 200, '00001',"접근 권한이 없으므로 글읽기가 불가합니다.<br>궁금하신 사항은 관리자에게 문의 바랍니다.");
                 }
             }
         }
     
         // 로그인된 회원의 권한이 설정된 읽기 권한보다 작다면
         if ($member['mb_level'] < $board['bo_read_level']) {
             if ($is_member)
             json_return('', 200, '00001','글을 읽을 권한이 없습니다.');
             else
             json_return('', 200, '00001','글을 읽을 권한이 없습니다.<br>회원이시라면 로그인 후 이용해 보십시오.');
         }
     
         // 본인확인을 사용한다면
         if ($board['bo_use_cert'] != '' && $config['cf_cert_use'] && !$is_admin) {
             // 인증된 회원만 가능
             if ($is_guest) {
                json_return('', 200, '00001','이 게시판은 본인확인 하신 회원님만 글읽기가 가능합니다.<br>회원이시라면 로그인 후 이용해 보십시오.');
             }
     
             if (strlen($member['mb_dupinfo']) == 64 && $member['mb_certify']) { // 본인 인증 된 계정 중에서 di로 저장 되었을 경우에만
                 goto_url(G5_BBS_URL."/member_cert_refresh.php?url=".urlencode(get_pretty_url($bo_table, $wr_id, $qstr)));
             }
     
             if ($board['bo_use_cert'] == 'cert' && !$member['mb_certify']) {            
                json_return('', 200, '00001','이 게시판은 본인확인 하신 회원님만 글읽기가 가능합니다.<br>회원정보 수정에서 본인확인을 해주시기 바랍니다.');
             }
     
             if ($board['bo_use_cert'] == 'adult' && !$member['mb_adult']) {
                json_return('', 200, '00001','이 게시판은 본인확인으로 성인인증 된 회원님만 글읽기가 가능합니다.<br>현재 성인인데 글읽기가 안된다면 회원정보 수정에서 본인확인을 다시 해주시기 바랍니다.');
             }
         }
     
         // 자신의 글이거나 관리자라면 통과
         if (($write['mb_id'] && $write['mb_id'] === $member['mb_id']) || $is_admin) {
             ;
         } else {
             // 비밀글이라면
             if (strstr($write['wr_option'], "secret"))
             {
                 // 회원이 비밀글을 올리고 관리자가 답변글을 올렸을 경우
                 // 회원이 관리자가 올린 답변글을 바로 볼 수 없던 오류를 수정
                 $is_owner = false;
                 if ($write['wr_reply'] && $member['mb_id'])
                 {
                     $sql = " select mb_id from {$write_table}
                                 where wr_num = '{$write['wr_num']}'
                                 and wr_reply = ''
                                 and wr_is_comment = 0 ";
                     $row = sql_fetch($sql);
                     if ($row['mb_id'] === $member['mb_id'])
                         $is_owner = true;
                 }
     
                 $ss_name = 'ss_secret_'.$bo_table.'_'.$write['wr_num'];
     
                 if (!$is_owner)
                 {
                     //$ss_name = "ss_secret_{$bo_table}_{$wr_id}";
                     // 한번 읽은 게시물의 번호는 세션에 저장되어 있고 같은 게시물을 읽을 경우는 다시 비밀번호를 묻지 않습니다.
                     // 이 게시물이 저장된 게시물이 아니면서 관리자가 아니라면
                     //if ("$bo_table|$write['wr_num']" != get_session("ss_secret"))
                     if (!get_session($ss_name))
                         goto_url(G5_BBS_URL.'/password.php?w=s&amp;bo_table='.$bo_table.'&amp;wr_id='.$wr_id.$qstr);
                 }
     
                 set_session($ss_name, TRUE);
             }
         }
     
         // 한번 읽은글은 브라우저를 닫기전까지는 카운트를 증가시키지 않음
         $ss_name = 'ss_view_'.$bo_table.'_'.$wr_id;
         if (!get_session($ss_name))
         {
             sql_query(" update {$write_table} set wr_hit = wr_hit + 1 where wr_id = '{$wr_id}' ");
     
             // 자신의 글이면 통과
             if ($write['mb_id'] && $write['mb_id'] === $member['mb_id']) {
                 ;
             } else if ($is_guest && $board['bo_read_level'] == 1 && $write['wr_ip'] == $_SERVER['REMOTE_ADDR']) {
                 // 비회원이면서 읽기레벨이 1이고 등록된 아이피가 같다면 자신의 글이므로 통과
                 ;
             } else {
                 // 글읽기 포인트가 설정되어 있다면
                 if ($config['cf_use_point'] && $board['bo_read_point'] && $member['mb_point'] + $board['bo_read_point'] < 0)
                 json_return('', 200,'00003', '보유하신 포인트('.number_format($member['mb_point']).')가 없거나 모자라서 글읽기('.number_format($board['bo_read_point']).')가 불가합니다.<br>포인트를 모으신 후 다시 글읽기 해 주십시오.');
     
                 insert_point($member['mb_id'], $board['bo_read_point'], ((G5_IS_MOBILE && $board['bo_mobile_subject']) ? $board['bo_mobile_subject'] : $board['bo_subject']).' '.$wr_id.' 글읽기', $bo_table, $wr_id, '읽기');
             }
     
             set_session($ss_name, TRUE);
         }
     
         $g5['title'] = strip_tags(conv_subject($write['wr_subject'], 255))." > ".$g5['board_title'];
     } else {
         if ($member['mb_level'] < $board['bo_list_level']) {
             if ($member['mb_id'])
                  json_return('', 200,'00001', '목록을 볼 권한이 없습니다.');
             else
                  json_return($member, 200,'00002','목록을 볼 권한이 없습니다.<br>회원이시라면 로그인 후 이용해 보십시오.');
         }
     
         // 본인확인을 사용한다면
         if ($board['bo_use_cert'] != '' && $config['cf_cert_use'] && !$is_admin) {
             // 인증된 회원만 가능
             if ($is_guest) {
                  json_return('', 200,'00005', '이 게시판은 본인확인 하신 회원님만 글읽기가 가능합니다.<br>회원이시라면 로그인 후 이용해 보십시오.');
             }
     
             if (strlen($member['mb_dupinfo']) == 64 && $member['mb_certify']) { // 본인 인증 된 계정 중에서 di로 저장 되었을 경우에만
                json_return('', 200,'00005', '이 게시판은 본인확인 하신 회원님만 글읽기가 가능합니다.<br>회원정보 수정에서 본인확인을 해주시기 바랍니다.');
                goto_url(G5_BBS_URL."/member_cert_refresh.php?url=".urlencode(get_pretty_url($bo_table, $wr_id, $qstr)));
             }
     
             if ($board['bo_use_cert'] == 'cert' && !$member['mb_certify']) {            
                  json_return('', 200,'00005', '이 게시판은 본인확인 하신 회원님만 글읽기가 가능합니다.<br>회원정보 수정에서 본인확인을 해주시기 바랍니다.');
             }
     
             if ($board['bo_use_cert'] == 'adult' && !$member['mb_adult']) {
                  json_return('', 200, '00004', '이 게시판은 본인확인으로 성인인증 된 회원님만 글읽기가 가능합니다.<br>현재 성인인데 글읽기가 안된다면 회원정보 수정에서 본인확인을 다시 해주시기 바랍니다.');
             }
         }
     
         if (!isset($page) || (isset($page) && $page == 0)) $page = 1;
     
         $g5['title'] = $g5['board_title'].' '.$page.' 페이지';
        

     }
     
  
//게시물 불러오기
if (isset($wr_id) && $wr_id) {
//함수로 불러오기
   $result = api_board_view($bo_table,$write_table,$write,$wr_id,$page,$page_rows);
//include 해서 불러오기
//include_once(G5_API_PATH.'/bbs/view.php');
$msg = "게시물 불러오기에 성공하였습니다.";
}

      
// 게시판 목록 불러오기
if ($member['mb_level'] >= $board['bo_list_level'] && $board['bo_use_list_view'] || empty($wr_id)){

    //함수로 불러오기
 //  $result = api_board_list($bo_table,$write_table,$stx,$sop,$sca,$sst,$sod,$page,$page_rows);
  //include 해서 불러오기
include_once(G5_API_PATH.'/bbs/list.php');
//함수로 불러오나 include 해서 불러오나 속도 차이는 나지 않음 그래서 include로 불러오는게 더 편함
//그리고 한 파일에 너무 많은 내용을 넣으면 가독성이 떨어지기 때문에 include로 불러오는게 더 좋음

$msg = "게시판 목록 불러오기에 성공하였습니다.";
}

   
    $result['title'] = $g5['title'];
   // $result['board'] = $board;
     json_return($result, 200,'00000', $msg);

}

// 이하 내용은 속도 테스트 용으로 당문간 남겨둠
function api_board_list($bo_table,$write_table,$stx,$sop,$sca,$sst,$sod,$page,$page_rows){
    global $g5;
    global $config;
    global $default;
    global $member;
    global $board;
   

    // 분류 사용 여부
    $is_category = false;
    $category_option = '';
    if ($board['bo_use_category']) {
        $is_category = true;
        // $category_href = get_pretty_url($bo_table);

        // $category_option .= '<li><a href="'.$category_href.'"';
        // if ($sca=='')
        //     $category_option .= ' id="bo_cate_on"';
        // $category_option .= '>전체</a></li>';

        // $categories = explode('|', $board['bo_category_list']); // 구분자가 , 로 되어 있음
        // for ($i=0; $i<count($categories); $i++) {
        //     $category = trim($categories[$i]);
        //     if ($category=='') continue;
        //     $category_option .= '<li><a href="'.(get_pretty_url($bo_table,'','sca='.urlencode($category))).'"';
        //     $category_msg = '';
        //     if ($category==$sca) { // 현재 선택된 카테고리라면
        //         $category_option .= ' id="bo_cate_on"';
        //         $category_msg = '<span class="sound_only">열린 분류 </span>';
        //     }
        //     $category_option .= '>'.$category_msg.$category.'</a></li>';
        // }

        $category_option =   $board['bo_category_list'];

    }

    $sop = strtolower($sop);
    if ($sop != 'and' && $sop != 'or')
        $sop = 'and';

    // 분류 선택 또는 검색어가 있다면
    $stx = trim($stx);
    //검색인지 아닌지 구분하는 변수 초기화
    $is_search_bbs = false;

    if ($sca || $stx || $stx === '0') {     //검색이면
        $is_search_bbs = true;      //검색구분변수 true 지정
        $sql_search = get_sql_search($sca, $sfl, $stx, $sop);

        // 가장 작은 번호를 얻어서 변수에 저장 (하단의 페이징에서 사용)
        $sql = " select MIN(wr_num) as min_wr_num from {$write_table} ";
        $row = sql_fetch($sql);
        $min_spt = (int)$row['min_wr_num'];

        if (!$spt) $spt = $min_spt;

        $sql_search .= " and (wr_num between {$spt} and ({$spt} + {$config['cf_search_part']})) ";

        // 원글만 얻는다. (코멘트의 내용도 검색하기 위함)
        // 라엘님 제안 코드로 대체 http://sir.kr/g5_bug/2922
        $sql = " SELECT COUNT(DISTINCT `wr_parent`) AS `cnt` FROM {$write_table} WHERE {$sql_search} ";
        $row = sql_fetch($sql);
        $total_count = $row['cnt'];
        /*
        $sql = " select distinct wr_parent from {$write_table} where {$sql_search} ";
        $result = sql_query($sql);
        $total_count = sql_num_rows($result);
        */
    } else {
        $sql_search = "";

        $total_count = $board['bo_count_write'];
    }

    if(G5_IS_MOBILE) {
        $page_rows = $board['bo_mobile_page_rows'];
        $list_page_rows = $board['bo_mobile_page_rows'];
    } else {
        $page_rows = $board['bo_page_rows'];
        $list_page_rows = $board['bo_page_rows'];
    }

    if ($page < 1) { $page = 1; } // 페이지가 없으면 첫 페이지 (1 페이지)

    // 년도 2자리
    $today2 = G5_TIME_YMD;

    $list = array();
    $i = 0;
    $notice_count = 0;
    $notice_array = array();

    // 공지 처리
    if (!$is_search_bbs) {
        $arr_notice = explode(',', trim($board['bo_notice']));
        $from_notice_idx = ($page - 1) * $page_rows;
        if($from_notice_idx < 0)
            $from_notice_idx = 0;
        $board_notice_count = count($arr_notice);

        for ($k=0; $k<$board_notice_count; $k++) {
            if (trim($arr_notice[$k]) == '') continue;

            $row = sql_fetch(" select * from {$write_table} where wr_id = '{$arr_notice[$k]}' ");

            if (!isset($row['wr_id']) || !$row['wr_id']) continue;

            $notice_array[] = $row['wr_id'];

            if($k < $from_notice_idx) continue;

            $list[$i] = get_list($row, $board, $board_skin_url, G5_IS_MOBILE ? $board['bo_mobile_subject_len'] : $board['bo_subject_len']);
            $list[$i]['is_notice'] = true;
            $list[$i]['num'] = 0;
            $i++;
            $notice_count++;

            if($notice_count >= $list_page_rows)
                break;
        }
    }

    $total_page  = ceil($total_count / $page_rows);  // 전체 페이지 계산
    $from_record = ($page - 1) * $page_rows; // 시작 열을 구함

    // 공지글이 있으면 변수에 반영
    if(!empty($notice_array)) {
        $from_record -= count($notice_array);

        if($from_record < 0)
            $from_record = 0;

        if($notice_count > 0)
            $page_rows -= $notice_count;

        if($page_rows < 0)
            $page_rows = $list_page_rows;
    }

    // 관리자라면 CheckBox 보임
    $is_checkbox = false;
    if ($is_member && ($is_admin == 'super' || $group['gr_admin'] == $member['mb_id'] || $board['bo_admin'] == $member['mb_id']))
        $is_checkbox = true;

    // 정렬에 사용하는 QUERY_STRING
    $qstr2 = 'bo_table='.$bo_table.'&amp;sop='.$sop;

    // 0 으로 나눌시 오류를 방지하기 위하여 값이 없으면 1 로 설정
    $bo_gallery_cols = $board['bo_gallery_cols'] ? $board['bo_gallery_cols'] : 1;
    $td_width = (int)(100 / $bo_gallery_cols);

    // 정렬
    // 인덱스 필드가 아니면 정렬에 사용하지 않음
    //if (!$sst || ($sst && !(strstr($sst, 'wr_id') || strstr($sst, "wr_datetime")))) {
    if (!$sst) {
        if ($board['bo_sort_field']) {
            $sst = $board['bo_sort_field'];
        } else {
            $sst  = "wr_num, wr_reply";
            $sod = "";
        }
    } else {
        $board_sort_fields = get_board_sort_fields($board, 1);
        if (!$sod && array_key_exists($sst, $board_sort_fields)) {
            $sst = $board_sort_fields[$sst];
        } else {
            // 게시물 리스트의 정렬 대상 필드가 아니라면 공백으로 (nasca 님 09.06.16)
            // 리스트에서 다른 필드로 정렬을 하려면 아래의 코드에 해당 필드를 추가하세요.
            // $sst = preg_match("/^(wr_subject|wr_datetime|wr_hit|wr_good|wr_nogood)$/i", $sst) ? $sst : "";
            $sst = preg_match("/^(wr_datetime|wr_hit|wr_good|wr_nogood)$/i", $sst) ? $sst : "";
        }
    }

    if(!$sst)
        $sst  = "wr_num, wr_reply";

    if ($sst) {
        $sql_order = " order by {$sst} {$sod} ";
    }

    if ($is_search_bbs) {
        $sql = " select distinct wr_parent from {$write_table} where {$sql_search} {$sql_order} limit {$from_record}, $page_rows ";
    } else {
        $sql = " select * from {$write_table} where wr_is_comment = 0 ";
        if(!empty($notice_array))
            $sql .= " and wr_id not in (".implode(', ', $notice_array).") ";
        $sql .= " {$sql_order} limit {$from_record}, $page_rows ";
    }

    // 페이지의 공지개수가 목록수 보다 작을 때만 실행
    if($page_rows > 0) {
        $result = sql_query($sql);

        $k = 0;

        while ($row = sql_fetch_array($result))
        {
            // 검색일 경우 wr_id만 얻었으므로 다시 한행을 얻는다
            if ($is_search_bbs)
                $row = sql_fetch(" select * from {$write_table} where wr_id = '{$row['wr_parent']}' ");

            $list[$i] = get_list($row, $board, $board_skin_url, G5_IS_MOBILE ? $board['bo_mobile_subject_len'] : $board['bo_subject_len']);
            if (strstr($sfl, 'subject')) {
                $list[$i]['subject'] = search_font($stx, $list[$i]['subject']);
            }
            $list[$i]['is_notice'] = false;
            $list_num = $total_count - ($page - 1) * $list_page_rows - $notice_count;
            $list[$i]['num'] = $list_num - $k;

            $i++;
            $k++;
        }
    }

    g5_latest_cache_data($board['bo_table'], $list);

    $write_pages = get_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, get_pretty_url($bo_table, '', $qstr.'&amp;page='));

    $list_href = '';
    $prev_part_href = '';
    $next_part_href = '';
    if ($is_search_bbs) {
        $list_href = get_pretty_url($bo_table);

        $patterns = array('#&amp;page=[0-9]*#', '#&amp;spt=[0-9\-]*#');

        //if ($prev_spt >= $min_spt)
        $prev_spt = $spt - $config['cf_search_part'];
        if (isset($min_spt) && $prev_spt >= $min_spt) {
            $qstr1 = preg_replace($patterns, '', $qstr);
            $prev_part_href = get_pretty_url($bo_table,0,$qstr1.'&amp;spt='.$prev_spt.'&amp;page=1');
            $write_pages = page_insertbefore($write_pages, '<a href="'.$prev_part_href.'" class="pg_page pg_search pg_prev">이전검색</a>');
        }

        $next_spt = $spt + $config['cf_search_part'];
        if ($next_spt < 0) {
            $qstr1 = preg_replace($patterns, '', $qstr);
            $next_part_href = get_pretty_url($bo_table,0,$qstr1.'&amp;spt='.$next_spt.'&amp;page=1');
            $write_pages = page_insertafter($write_pages, '<a href="'.$next_part_href.'" class="pg_page pg_search pg_next">다음검색</a>');
        }
    }


    $write_href = '';
    if ($member['mb_level'] >= $board['bo_write_level']) {
        $write_href = short_url_clean(G5_BBS_URL.'/write.php?bo_table='.$bo_table);
    }

    $nobr_begin = $nobr_end = "";
    if (preg_match("/gecko|firefox/i", $_SERVER['HTTP_USER_AGENT'])) {
        $nobr_begin = '<nobr>';
        $nobr_end   = '</nobr>';
    }

    // RSS 보기 사용에 체크가 되어 있어야 RSS 보기 가능 061106
    $rss_href = '';
    if ($board['bo_use_rss_view']) {
        $rss_href = G5_BBS_URL.'/rss.php?bo_table='.$bo_table;
    }

    $stx = get_text(stripslashes($stx));

    $list_result['board'] =$board;
    $list_result['board_skin_url'] =$board_skin_url;
    $list_result['is_admin'] =$is_admin;
    $list_result['is_category'] =$is_category;
    $list_result['category_option'] =$category_option;
    $list_result['total_page'] = $total_page;
    $list_result['list'] =$list;
    $list_result['write_pages'] =$write_pages;
    $list_result['list_href'] =$list_href;
    $list_result['prev_part_href'] =$prev_part_href;
    $list_result['next_part_href'] =$next_part_href;
    $list_result['write_href'] =$write_href;
    $list_result['nobr_begin'] =$nobr_begin;
    $list_result['nobr_end'] =$nobr_end;
    $list_result['rss_href'] =$rss_href;
    $list_result['stx'] =$stx;



    return $list_result;
}

function api_board_view($bo_table,$write_table,$write,$wr_id,$page,$page_rows){

    global $g5;
    global $config;
    global $default;


// 게시판에서 두단어 이상 검색 후 검색된 게시물에 코멘트를 남기면 나오던 오류 수정
$sop = strtolower($sop);
if ($sop != 'and' && $sop != 'or')
    $sop = 'and';

$result['sop'] = $sop;

//@include_once($board_skin_path.'/view.head.skin.php');

$sql_search = "";
// 검색이면
if ($sca || $stx || $stx === '0') {
    // where 문을 얻음
    $sql_search = get_sql_search($sca, $sfl, $stx, $sop);
    $search_href = get_pretty_url($bo_table,'','&amp;page='.$page.$qstr);
    $list_href = get_pretty_url($bo_table);
} else {
    $search_href = '';
    $list_href = get_pretty_url($bo_table,'',$qstr);
}

$result['search_href'] = $search_href;
$result['list_href'] = $list_href;

if (!$board['bo_use_list_view']) {
    if ($sql_search)
        $sql_search = " and " . $sql_search;

    // 윗글을 얻음
    $sql = " select wr_id, wr_subject, wr_datetime from {$write_table} where wr_is_comment = 0 and wr_num = '{$write['wr_num']}' and wr_reply < '{$write['wr_reply']}' {$sql_search} order by wr_num desc, wr_reply desc limit 1 ";
    $prev = sql_fetch($sql);
    // 위의 쿼리문으로 값을 얻지 못했다면
    if (! (isset($prev['wr_id']) && $prev['wr_id'])) {
        $sql = " select wr_id, wr_subject, wr_datetime from {$write_table} where wr_is_comment = 0 and wr_num < '{$write['wr_num']}' {$sql_search} order by wr_num desc, wr_reply desc limit 1 ";
        $prev = sql_fetch($sql);
    }

    // 아래글을 얻음
    $sql = " select wr_id, wr_subject, wr_datetime from {$write_table} where wr_is_comment = 0 and wr_num = '{$write['wr_num']}' and wr_reply > '{$write['wr_reply']}' {$sql_search} order by wr_num, wr_reply limit 1 ";
    $next = sql_fetch($sql);
    // 위의 쿼리문으로 값을 얻지 못했다면
    if (! (isset($next['wr_id']) && $next['wr_id'])) {
        $sql = " select wr_id, wr_subject, wr_datetime from {$write_table} where wr_is_comment = 0 and wr_num > '{$write['wr_num']}' {$sql_search} order by wr_num, wr_reply limit 1 ";
        $next = sql_fetch($sql);
    }
}

// 이전글 링크
$prev_href = '';
if (isset($prev['wr_id']) && $prev['wr_id']) {
    $prev_wr_subject = get_text(cut_str($prev['wr_subject'], 255));
    $prev_href = get_pretty_url($bo_table, $prev['wr_id'], $qstr);
    $prev_wr_date = $prev['wr_datetime'];
}

$result['prev_wr_subject'] = $prev_wr_subject;
$result['prev_href'] = $prev_href;
$result['prev_wr_date'] = $prev_wr_date;

// 다음글 링크
$next_href = '';
if (isset($next['wr_id']) && $next['wr_id']) {
    $next_wr_subject = get_text(cut_str($next['wr_subject'], 255));
    $next_href = get_pretty_url($bo_table, $next['wr_id'], $qstr);
    $next_wr_date = $next['wr_datetime'];
}
$result['next_wr_subject'] = $next_wr_subject;
$result['next_href'] = $next_href;
$result['next_wr_date'] = $next_wr_date;

// 쓰기 링크
$write_href = '';
if ($member['mb_level'] >= $board['bo_write_level']) {
    $write_href = short_url_clean(G5_BBS_URL.'/write.php?bo_table='.$bo_table);
}
$result['write_href'] = $write_href;

// 답변 링크
$reply_href = '';
if ($member['mb_level'] >= $board['bo_reply_level']) {
    $reply_href = short_url_clean(G5_BBS_URL.'/write.php?w=r&amp;bo_table='.$bo_table.'&amp;wr_id='.$wr_id.$qstr);
}
$result['reply_href'] = $reply_href;

// 수정, 삭제 링크
$update_href = $delete_href = '';
// 로그인중이고 자신의 글이라면 또는 관리자라면 비밀번호를 묻지 않고 바로 수정, 삭제 가능
if (($member['mb_id'] && ($member['mb_id'] === $write['mb_id'])) || $is_admin) {
    $update_href = short_url_clean(G5_BBS_URL.'/write.php?w=u&amp;bo_table='.$bo_table.'&amp;wr_id='.$wr_id.'&amp;page='.$page.$qstr);
    set_session('ss_delete_token', $token = uniqid(time()));
    $delete_href = G5_BBS_URL.'/delete.php?bo_table='.$bo_table.'&amp;wr_id='.$wr_id.'&amp;token='.$token.'&amp;page='.$page.urldecode($qstr);
}
else if (!$write['mb_id']) { // 회원이 쓴 글이 아니라면
    $update_href = G5_BBS_URL.'/password.php?w=u&amp;bo_table='.$bo_table.'&amp;wr_id='.$wr_id.'&amp;page='.$page.$qstr;
    $delete_href = G5_BBS_URL.'/password.php?w=d&amp;bo_table='.$bo_table.'&amp;wr_id='.$wr_id.'&amp;page='.$page.$qstr;
}

$result['update_href'] = $update_href;
$result['delete_href'] = $delete_href;

// 최고, 그룹관리자라면 글 복사, 이동 가능
$copy_href = $move_href = '';
if ($write['wr_reply'] == '' && ($is_admin == 'super' || $is_admin == 'group')) {
    $copy_href = G5_BBS_URL.'/move.php?sw=copy&amp;bo_table='.$bo_table.'&amp;wr_id='.$wr_id.'&amp;page='.$page.$qstr;
    $move_href = G5_BBS_URL.'/move.php?sw=move&amp;bo_table='.$bo_table.'&amp;wr_id='.$wr_id.'&amp;page='.$page.$qstr;
}
$result['copy_href'] = $copy_href;
$result['move_href'] = $move_href;

$scrap_href = '';
$good_href = '';
$nogood_href = '';
if ($is_member) {
    // 스크랩 링크
    $scrap_href = G5_BBS_URL.'/scrap_popin.php?bo_table='.$bo_table.'&amp;wr_id='.$wr_id;

    // 추천 링크
    if ($board['bo_use_good'])
        $good_href = G5_BBS_URL.'/good.php?bo_table='.$bo_table.'&amp;wr_id='.$wr_id.'&amp;good=good';

    // 비추천 링크
    if ($board['bo_use_nogood'])
        $nogood_href = G5_BBS_URL.'/good.php?bo_table='.$bo_table.'&amp;wr_id='.$wr_id.'&amp;good=nogood';
}
$result['scrap_href'] = $scrap_href;
$result['good_href'] = $good_href;
$result['nogood_href'] = $nogood_href;

$view = get_view($write, $board, $board_skin_path);

if (strstr($sfl, 'subject'))
    $view['subject'] = search_font($stx, $view['subject']);

$html = 0;
if (strstr($view['wr_option'], 'html1'))
    $html = 1;
else if (strstr($view['wr_option'], 'html2'))
    $html = 2;

$view['content'] = conv_content($view['wr_content'], $html);
if (strstr($sfl, 'content'))
    $view['content'] = search_font($stx, $view['content']);

//$view['rich_content'] = preg_replace("/{이미지\:([0-9]+)[:]?([^}]*)}/ie", "view_image(\$view, '\\1', '\\2')", $view['content']);
function conv_rich_content($matches)
{
    global $view;
    return view_image($view, $matches[1], $matches[2]);
}
$view['rich_content'] = preg_replace_callback("/{이미지\:([0-9]+)[:]?([^}]*)}/i", "conv_rich_content", $view['content']);


$is_signature = false;
$signature = '';
if ($board['bo_use_signature'] && $view['mb_id']) {
    $is_signature = true;
    $mb = get_member($view['mb_id']);
    $signature = $mb['mb_signature'];

    $signature = conv_content($signature, 1);
}

$view['ip'] = $view['wr_ip'];
if (!$is_admin)
    $view['ip'] = preg_replace("/([0-9]+).([0-9]+).([0-9]+).([0-9]+)/", G5_IP_DISPLAY, $view['wr_ip']);



$result['view'] = $view;
$result['signature'] = $signature;



return $result;
}



function View_comment(){

    global $g5;
    global $config;
    global $default;
    global $member;
    global $board;
    global $is_admin;
    global $is_member;
    global $is_guest;
    global $group;
    global $write;

    $requestData = json_decode(file_get_contents('php://input'), true);

    // Get the username and password from the request data
    $bo_table = $requestData['bo_table'];
    $wr_id = $requestData['wr_id'];

    if ($bo_table) {
        $board = get_board_db($bo_table, true);
        if (isset($board['bo_table']) && $board['bo_table']) {
            set_cookie("ck_bo_table", $board['bo_table'], 86400 * 1);
            $gr_id = $board['gr_id'];
            $write_table = $g5['write_prefix'] . $bo_table; // 게시판 테이블 전체이름
    
            if (isset($wr_id) && $wr_id) {
                $write = get_write($write_table, $wr_id);
            } else if (isset($wr_seo_title) && $wr_seo_title) {
                $write = get_content_by_field($write_table, 'bbs', 'wr_seo_title', generate_seo_title($wr_seo_title));
                if( isset($write['wr_id']) ){
                    $wr_id = $write['wr_id'];
                }
            }
        }
        
        // 게시판에서 
        if (isset($board['bo_select_editor']) && $board['bo_select_editor']){
            $config['cf_editor'] = $board['bo_select_editor'];
        }
    }

    include_once(G5_CAPTCHA_PATH.'/captcha.lib.php');

$captcha_html = "";
if ($is_guest && $board['bo_comment_level'] < 2) {
    $captcha_html = captcha_html('_comment');
}

$c_id = isset($_GET['c_id']) ? clean_xss_tags($_GET['c_id'], 1, 1) : '';
$c_wr_content = '';

//@include_once($board_skin_path.'/view_comment.head.skin.php');

$list = array();

$is_comment_write = false;
if ($member['mb_level'] >= $board['bo_comment_level'])
    $is_comment_write = true;

// 코멘트 출력
//$sql = " select * from {$write_table} where wr_parent = '{$wr_id}' and wr_is_comment = 1 order by wr_comment desc, wr_comment_reply ";
$sql = " select * from $write_table where wr_parent = '$wr_id' and wr_is_comment = 1 order by wr_comment, wr_comment_reply ";
$result0 = sql_query($sql);
for ($i=0; $row=sql_fetch_array($result0); $i++)
{
    $list[$i] = $row;

    //$list[$i]['name'] = get_sideview($row['mb_id'], cut_str($row['wr_name'], 20, ''), $row['wr_email'], $row['wr_homepage']);

    $tmp_name = get_text(cut_str($row['wr_name'], $config['cf_cut_name'])); // 설정된 자리수 만큼만 이름 출력
    if ($board['bo_use_sideview'])
        $list[$i]['name'] = get_sideview($row['mb_id'], $tmp_name, $row['wr_email'], $row['wr_homepage']);
    else
        $list[$i]['name'] = '<span class="'.($row['mb_id']?'member':'guest').'">'.$tmp_name.'</span>';



    // 공백없이 연속 입력한 문자 자르기 (way 보드 참고. way.co.kr)
    //$list[$i]['content'] = eregi_replace("[^ \n<>]{130}", "\\0\n", $row['wr_content']);

    $list[$i]['content'] = $list[$i]['content1']= '비밀글 입니다.';
    if (!strstr($row['wr_option'], 'secret') ||
        $is_admin ||
        ($write['mb_id']===$member['mb_id'] && $member['mb_id']) ||
        ($row['mb_id']===$member['mb_id'] && $member['mb_id'])) {
        $list[$i]['content1'] = $row['wr_content'];
        $list[$i]['content'] = conv_content($row['wr_content'], 0, 'wr_content');
        $list[$i]['content'] = search_font($stx, $list[$i]['content']);
    } else {
        $ss_name = 'ss_secret_comment_'.$bo_table.'_'.$list[$i]['wr_id'];

        if(!get_session($ss_name))
            $list[$i]['content'] = '<a href="'.G5_BBS_URL.'/password.php?w=sc&amp;bo_table='.$bo_table.'&amp;wr_id='.$list[$i]['wr_id'].$qstr.'" class="s_cmt">댓글내용 확인</a>';
        else {
            $list[$i]['content'] = conv_content($row['wr_content'], 0, 'wr_content');
            $list[$i]['content'] = search_font($stx, $list[$i]['content']);
        }
    }

    $list[$i]['datetime'] = substr($row['wr_datetime'],2,14);

    // 관리자가 아니라면 중간 IP 주소를 감춘후 보여줍니다.
    $list[$i]['ip'] = $row['wr_ip'];
    if (!$is_admin)
        $list[$i]['ip'] = preg_replace("/([0-9]+).([0-9]+).([0-9]+).([0-9]+)/", G5_IP_DISPLAY, $row['wr_ip']);

    $list[$i]['is_reply'] = false;
    $list[$i]['is_edit'] = false;
    $list[$i]['is_del']  = false;
    if ($is_comment_write || $is_admin)
    {
        $token = '';

        if ($member['mb_id'])
        {
            if ($row['mb_id'] === $member['mb_id'] || $is_admin)
            {
                set_session('ss_delete_comment_'.$row['wr_id'].'_token', $token = uniqid(time()));
                $list[$i]['del_link']  = G5_BBS_URL.'/delete_comment.php?bo_table='.$bo_table.'&amp;comment_id='.$row['wr_id'].'&amp;token='.$token.'&amp;page='.$page.$qstr;
                $list[$i]['is_edit']   = true;
                $list[$i]['is_del']    = true;
            }
        }
        else
        {
            if (!$row['mb_id']) {
                $list[$i]['del_link'] = G5_BBS_URL.'/password.php?w=x&amp;bo_table='.$bo_table.'&amp;comment_id='.$row['wr_id'].'&amp;page='.$page.$qstr;
                $list[$i]['is_del']   = true;
            }
        }

        if (strlen($row['wr_comment_reply']) < 5)
            $list[$i]['is_reply'] = true;
    }

    // 05.05.22
    // 답변있는 코멘트는 수정, 삭제 불가
    if ($i > 0 && !$is_admin)
    {
        if ($row['wr_comment_reply'])
        {
            $tmp_comment_reply = substr($row['wr_comment_reply'], 0, strlen($row['wr_comment_reply']) - 1);
            if ($tmp_comment_reply == $list[$i-1]['wr_comment_reply'])
            {
                $list[$i-1]['is_edit'] = false;
                $list[$i-1]['is_del'] = false;
            }
        }
    }
}

//  코멘트수 제한 설정값
if ($is_admin)
{
    $comment_min = $comment_max = 0;
}
else
{
    $comment_min = (int)$board['bo_comment_min'];
    $comment_max = (int)$board['bo_comment_max'];
}
$result['comment_min'] = $comment_min;
$result['comment_max'] = $comment_max;


$comment_action_url = https_url(G5_BBS_DIR)."/write_comment_update.php";
$comment_common_url = short_url_clean(G5_BBS_URL.'/board.php?'.clean_query_string($_SERVER['QUERY_STRING']));
$result['comment_action_url'] = $comment_action_url;
$result['comment_common_url'] = $comment_common_url;

$result['list'] = $list;

$msg ="댓글 목록 불러오기에 성공하였습니다.";
json_return($result, 200,'00000', $msg);
}
