<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가


// 메뉴 불러오기
function Index(){

    global $g5;
    global $config;
    global $default;

    $requestData = json_decode(file_get_contents('php://input'), true);

    // Get the username and password from the request data
    $co_id = $requestData['co_id'];
    $co_seo_title = $requestData['co_seo_title'];

    $co_id = isset($co_id) ? preg_replace('/[^a-z0-9_]/i', '', $co_id) : 0;
    $co_seo_title = isset($co_seo_title) ? clean_xss_tags($co_seo_title, 1, 1) : '';



    //dbconfig파일에 $g5['content_table'] 배열변수가 있는지 체크
    if( !isset($g5['content_table']) ){
        //die('<meta charset="utf-8">관리자 모드에서 게시판관리->내용 관리를 먼저 확인해 주세요.');
        json_return('', 200, '0000000001','관리자 모드에서 게시판관리->내용 관리를 먼저 확인해 주세요.');
    }


    // 내용
    if($co_seo_title){
        $co = get_content_by_field($g5['content_table'], 'content', 'co_seo_title', generate_seo_title($co_seo_title));
        $co_id = isset($co['co_id']) ? $co['co_id'] : 0;
    } else {
        $co = get_content_db($co_id);
    }

        
    // KVE-2019-0828 취약점 내용
    $co['co_tag_filter_use'] = 1;
    $str = conv_content($co['co_content'], $co['co_html'], $co['co_tag_filter_use']);

    // $src 를 $dst 로 변환
    $src = $dst = array();
    $src[] = "/{{쇼핑몰명}}|{{홈페이지제목}}/";
    $dst[] = $config['cf_title'];
    if(isset($default) && isset($default['de_admin_company_name'])){
        $src[] = "/{{회사명}}|{{상호}}/";
        $dst[] = isset($default['de_admin_company_name']) ? $default['de_admin_company_name'] : '';
        $src[] = "/{{대표자명}}/";
        $dst[] = isset($default['de_admin_company_owner']) ? $default['de_admin_company_owner'] : '';
        $src[] = "/{{사업자등록번호}}/";
        $dst[] = isset($default['de_admin_company_saupja_no']) ? $default['de_admin_company_saupja_no'] : '';
        $src[] = "/{{대표전화번호}}/";
        $dst[] = isset($default['de_admin_company_tel']) ? $default['de_admin_company_tel'] : '';
        $src[] = "/{{팩스번호}}/";
        $dst[] = isset($default['de_admin_company_fax']) ? $default['de_admin_company_fax'] : '';
        $src[] = "/{{통신판매업신고번호}}/";
        $dst[] = isset($default['de_admin_company_tongsin_no']) ? $default['de_admin_company_tongsin_no'] : '';
        $src[] = "/{{사업장우편번호}}/";
        $dst[] = isset($default['de_admin_company_zip']) ? $default['de_admin_company_zip'] : '';
        $src[] = "/{{사업장주소}}/";
        $dst[] = isset($default['de_admin_company_addr']) ? $default['de_admin_company_addr'] : '';
        $src[] = "/{{운영자명}}|{{관리자명}}/";
        $dst[] = isset($default['de_admin_name']) ? $default['de_admin_name'] : '';
        $src[] = "/{{운영자e-mail}}|{{관리자e-mail}}/i";
        $dst[] = isset($default['de_admin_email']) ? $default['de_admin_email'] : '';
        $src[] = "/{{정보관리책임자명}}/";
        $dst[] = isset($default['de_admin_info_name']) ? $default['de_admin_info_name'] : '';
        $src[] = "/{{정보관리책임자e-mail}}|{{정보책임자e-mail}}/i";
        $dst[] = isset($default['de_admin_info_email']) ? $default['de_admin_info_email'] : '';
    }
    $result['title'] = $co['co_subject'];
    $result['content'] = preg_replace($src, $dst, $str);

    $himg = G5_DATA_PATH.'/content/'.$co_id.'_h';
        if (file_exists($himg))
    $result['himg'] = G5_DATA_URL.'/content/'.$co_id.'_h';

    $himg = G5_DATA_PATH.'/content/'.$co_id.'_t';
        if (file_exists($himg))
    $result['timg'] = G5_DATA_URL.'/content/'.$co_id.'_t';



    include_once G5_API_PATH. '/lib/jwt.php';

    $jwt = new JWT("ES256");
    $headers = getallheaders();
    $token = $headers['Authorization'];
   // $token = $_SERVER['HTTP_AUTHORIZATION'];
  
    $token = str_replace("Bearer ", "", $token);
    $result['jwt'] = $token;
    $algs[] = "HS256";
    $token = $jwt->decode($token, G5_JWT_ACCESS_TOKEN_KEY, $algs);
    $result['token'] = $token;
    $mb_id = $token->mb_id;


    $result['test'] = $member;


    json_return($result, 200, '00000','내용을 불러왔습니다.');

}