<?php
include_once './_common.php';
$g5_debug['php']['begin_time'] = $begin_time = get_microtime();
////////////////////////////////
// 작성자 : 임종필(jp9731kr@gmail.com)
// 작성일 : 2023-02-23
// 작성내용 : Restful API 기능 구현
// 버전 : 0.1
////////////////////////////////

/*
개요
그누보드에서는 Restful API 기능을 제공하지 않습니다.
그래서 자주 사용하는 Restful API 기능위주로 간략하게 구현합니다. 
일반적으로 Restful API 는 class  를 이용하여 구현하지만, 그누보드는 class 를 사용하지 않기 때문에
그누보드 사용자들이 쉽게 이해하고 활용할 수 있게 함수를 이용하여 구현하였습니다.


Restful API 기능 요약 
1. URL을 통해 파일명과 함수명을 추출
2. 파일명과 함수명을 통해 해당 함수를 호출
3. 함수의 인자로 URL의 마지막 요소를 전달
4. 폴더를 통해 파일을 분류
5. 폴더틑 여러 깊이로 구성 가능
6. 함수명은 대문자로 시작해야 함
7. 함수의 인자는 1개만 사용 가능
8. 캐시를 사용하여 성능을 향상
9. 캐시를 사용하여 동일한 요청에 대해 동일한 결과를 반환

사용법
1. 시작폴더 api를 생성(이름은 변경 가능 ,변경시 .htaccess 파일내용도 같이 변경해야 함)
2. api 폴더에 index.php , _common.php, .htaccess 파일 복사 붙여넣기
- apache 의 경우 .htaccess 파일을 사용하여 URL을 통해 파일명과 함수명을 추출
- nginx 의 경우 nginx.conf 파일을 사용하여 URL을 통해 파일명과 함수명을 추출
3. api 폴더에 폴더를 생성하고 그안에 php 파일을 생성
4. php 파일에 함수를 생성
5. 함수명은 대문자로 시작해야 함(외부에서 호출하기 위해)
6. 함수의 인자는 1개만 사용 가능
7. 함수의 인자는 URL의 마지막 요소를 전달
8. URL을 통해 함수를 호출
9. URL 예시 : http://localhost/api/폴더명/폴더명/폴더명/파일명/함수명/인자
10. URL 예시 : http://localhost/api/폴더명/폴더명/폴더명/파일명/함수명
11. URL 예시 : http://localhost/api/폴더명/폴더명/폴더명/파일명
12. URL 마지막이 파일명일 때는 함수명을 생략하면 Index 함수를 호출

예시
1. api 폴더에 member 폴더를 생성
2. member 폴더에 member.php 파일을 생성
3. member.php 파일에 Index 함수를 생성
4. Index 함수의 인자로 URL의 마지막 요소를 전달
5. URL 예시 : http://localhost/api/member/member/Index/인자
6. URL 예시 : http://localhost/api/member/member/Index

보안 이슈
1. 보안이 필요한 포지션
   가. 외부에서 요청시 api 폴더 안에서만 접근해야 함.
      - .htaccess 파일에서 설정
      - if (strpos($url, $allowed_path) === 0 && strpos($url, ".." ) === false ){
        url 이 특정 문자열로 시작되는지 확인 후, .. 문자열을 이용하여 상위로 올라가는지 검사



2. 보안이 필요한 함수
    가. 외부에서 요청시 실행되는 함수
        - call_user_func 함수 호출
        - 외부에서 호출하는 함수는 대문자로 시작해야 함

    나. 외부에서 요청시 실행되는 함수의 인자
        - call_user_func_array 함수 호출
        - 외부에서 호출하는 함수의 인자는 1개만 사용 가능 / 그외에는 post 로 요청해야 함
    
3. 보안이 필요한 Get 인자
    가. xss 공격을 방지하기 위해 데이터를 저장후 실행 전에 데이터를 검사 (각 페이지에서 처리)
    나. sql injection 공격을 방지하기 위해 데이터를 저장후 실행 전에 데이터를 검사 (각 페이지에서 처리)
    다. 

4. 보안이 필요한 Post 데이터
    

*/



//설정 시작 --------------------------------------
//현재 시작 폴더


//현재 시작 폴더
define('G5_API_DIR',        'api');

define('G5_API_URL',        G5_URL.'/'.G5_API_DIR);
define('G5_API_PATH',       G5_PATH.'/'.G5_API_DIR);

define('G5_ORIGN_TYPE', 'dev'); //dev or release
define('G5_APP_URL', 'http://localhost'); //위 G5_ORIGN_TYPE release 시 사용

define('G5_JWT_ACCESS_TOKEN_KEY', 'long-jwt-key');
define('G5_JWT_REFESH_TOKEN_KEY', 'long-refresh');
define('G5_JWT_CRYPT_KEY', 'long-refresh-key'); //암호화 키
define('G5_JWT_AUDIENCE','gnuboard5.canweb.co.kr');
define('G5_JWT_ACCESS_MTIME',15); // ACCESS TOKEN 유지시간 단위 : 분
define('G5_JWT_RERESH_DATE', 30); // REFRESH TOKEN 유지시간 단취 : 일
define('G5_JWT_SNS_OAUTH_TIME', 24); // SNS OAUTH 로그인 유지시간 단위 : 시간 



//허용할 폴더
$allowed_path = "/".G5_API_DIR."/";

//마지막 요소를 인자로 사용시 인자의 데이터 타입을 지정
$arg_type = "string";//integer, string

//메소드명을 함수명 앞에 붙일지 여부 
$method_type = false; //true : 함수명 앞에 메소드명을 붙여서 사용, false : 함수명만 사용

//설정 끝 --------------------------------------

// Get the request method and URL
$method = $_SERVER['REQUEST_METHOD'];
$url = $_SERVER['REQUEST_URI'];

//보안 체크1. 문자열이 특정 문자열로 시작하는지 확인
if (strpos($url, $allowed_path) === 0 && strpos($url, ".." ) === false ){

    //$url 에서 현재 시작 폴더 삭제
    $url = str_replace($allowed_path, '', $url);
    // Get the parts of the URL
    $parts = explode('/', $url);

    // $parts 배열의 첫 번째 요소에서 시작하여 한 번에 한 레벨씩 올라가는 파일 검색
    $filePath = '';
    for ($i = count($parts); $i > 0; $i--) {
        $fileName = $parts[$i - 1] . '.php';
        $dirPath = implode('/', array_slice($parts, 0, $i - 1));

        if (!empty($dirPath)) {
            $dirPath = '/' . $dirPath;
        }

        $filePath = __DIR__ . $dirPath . '/' . $fileName;

        if (file_exists($filePath)) {
            break;
        }
    }
    //$filePath 의 시작이 /api/lib 로 시작하면 에러를 출력하고 종료
    if (strpos($filePath, "/".G5_API_DIR."/lib" ) === 0 ){
        // The URI is not allowed
        json_return('',404,'00001',"접근 금지된 경로입니다.");
        exit;
    }


    // 파일 존재 체크하고 파일이 존재하면 파일을 읽어옴
    if (file_exists($filePath)) {
 
        // URL에서 함수명 호출하기
        // 항수명이 숫자로 시작하면 함수명으로 사용하지 않음
        // && !is_numeric($parts[$i])

        if($parts[$i] && $parts[$i] != 'index.php'&& $parts[$i] != 'index'){
        $functionName = $parts[$i];

        // URL에서 인자값 가져오기
        $arg = $parts[$i + 1];
        
        }else{
        // 함수명이 없을 경우 Index 함수 호출
        $functionName = 'Index';

        // URL에서 인자값 가져오기
        $arg = $parts[$i];
        // Check filter_var for more validation
    
        
        }
        //인자값의 타입에 따른 보안 검사
        $type = gettype($arg);
        // 인자를 숫자만 받을 경우 아래 주석을 해제
        if($arg_type == 'integer'){
        
            if (filter_var($arg, FILTER_VALIDATE_INT) === false) {
                $arg = '';
            }
        }

        // 현재 파일의 전체 코드를 읽어오기
        $file = file_get_contents($filePath);

        if($method_type){
            //$method 의 값에 따라 함수명 호출
            // GET, POST, PUT, DELETE 는 함수 안에서 분기해서 사용하시는 편이 자유도가 높을 듯 합니다.
            if($method == 'GET'){
                $functionName = 'Get'.$functionName;
            }else if($method == 'POST'){
                $functionName = 'Post'.$functionName;
            }else if($method == 'PUT'){
                $functionName = 'Put'.$functionName;
            }else if($method == 'DELETE'){
                $functionName = 'Delete'.$functionName;
            }
        }

        // 함수명을 추출하기 위해 정규표현식 사용
        // 대문자로 시작하는 함수만 외부에서 호출할 수 있음
        preg_match_all('/function\s+([A-Z]\w+)\s*\(/', $file, $matches);

        // 함수명을 배열에 저장
        $function_names = $matches[1];

        //$functionName 첫글자 대문자로 변경
        $functionName = ucfirst($functionName);

        if(in_array($functionName, $function_names)){
            //크로스 도메인 허용
            header_origin();
            // Include the file
            include_once $filePath;

            // 함수 존재 체크 
            if (function_exists($functionName) ) {
                // JWT 토큰 검사
                $member = get_jwt_member();
               
                // 함수 호출
                call_user_func($functionName, $arg);
            }
                
        } else {
            json_return('',404,'00001',"페이지를 찾을 수 없습니다.");
        }
    }else {
        json_return('',404,'00001',"파일이 존재하지 않습니다.");

       
    }
} else {
    // The URI is not allowed
    json_return('',404,'00001',"파일이 존재하지 않습니다.");


}