<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

///api/lib/jwt.php 파일을 읽어옴
include_once G5_API_PATH. '/lib/jwt.php';


// Function to handle a login request
function Index() {
    
    
    $jwt = new JWT("ES256");

    // Get the request data
    $requestData = json_decode(file_get_contents('php://input'), true);

    // Get the username and password from the request data
    $mb_id = $requestData['mb_id'];
    $mb_password = $requestData['mb_password'];
 
    //$mb_id       = isset($_POST['mb_id']) ? trim($_POST['mb_id']) : '';
    //$mb_password = isset($_POST['mb_password']) ? trim($_POST['mb_password']) : '';

    run_event('member_login_check_before', $mb_id);

    if (!$mb_id || run_replace('check_empty_member_login_password', !$mb_password, $mb_id))
    json_return( $mb_id ,200, '00001','회원아이디나 비밀번호가 공백이면 안됩니다.');


    $mb = get_member($mb_id);


    //소셜 로그인추가 체크
    $is_social_login = false;
    $is_social_password_check = false;

    // 소셜 로그인이 맞는지 체크하고 해당 값이 맞는지 체크합니다.
    if(function_exists('social_is_login_check')){
        $is_social_login = social_is_login_check();

        //패스워드를 체크할건지 결정합니다.
        //소셜로그인일때는 체크하지 않고, 계정을 연결할때는 체크합니다.
        $is_social_password_check = social_is_login_password_check($mb_id);
    }

    $is_need_not_password = run_replace('login_check_need_not_password', $is_social_password_check, $mb_id, $mb_password, $mb, $is_social_login);

    // $is_need_not_password 변수가 true 이면 패스워드를 체크하지 않습니다.
    // 가입된 회원이 아니다. 비밀번호가 틀리다. 라는 메세지를 따로 보여주지 않는 이유는
    // 회원아이디를 입력해 보고 맞으면 또 비밀번호를 입력해보는 경우를 방지하기 위해서입니다.
    // 불법사용자의 경우 회원아이디가 틀린지, 비밀번호가 틀린지를 알기까지는 많은 시간이 소요되기 때문입니다.
    if (!$is_need_not_password && (! (isset($mb['mb_id']) && $mb['mb_id']) || !login_password_check($mb, $mb_password, $mb['mb_password'])) ) {

        run_event('password_is_wrong', 'login', $mb);

        json_return('',200,'00001', '가입된 회원아이디가 아니거나 비밀번호가 틀립니다.<br>비밀번호는 대소문자를 구분합니다.');
    }


    // 차단된 아이디인가?
    if ($mb['mb_intercept_date'] && $mb['mb_intercept_date'] <= date("Ymd", G5_SERVER_TIME)) {
        $date = preg_replace("/([0-9]{4})([0-9]{2})([0-9]{2})/", "\\1년 \\2월 \\3일", $mb['mb_intercept_date']);
        json_return('',200,'00001','회원님의 아이디는 접근이 금지되어 있습니다.<br>처리일 : '.$date);
    }

    // 탈퇴한 아이디인가?
    if ($mb['mb_leave_date'] && $mb['mb_leave_date'] <= date("Ymd", G5_SERVER_TIME)) {
        $date = preg_replace("/([0-9]{4})([0-9]{2})([0-9]{2})/", "\\1년 \\2월 \\3일", $mb['mb_leave_date']);
        json_return('',200,'00001','탈퇴한 아이디이므로 접근하실 수 없습니다.\n탈퇴일 : '.$date);
    }

    // 메일인증 설정이 되어 있다면
    if ( is_use_email_certify() && !preg_match("/[1-9]/", $mb['mb_email_certify'])) {
        $ckey = md5($mb['mb_ip'].$mb['mb_datetime']);
        json_return('',200,'00001',"{$mb['mb_email']} 메일로 메일인증을 받으셔야 로그인 가능합니다. 다른 메일주소로 변경하여 인증하시려면 취소를 클릭하시기 바랍니다.");
    }

    run_event('login_session_before', $mb, $is_social_login);


    // JWT Access Token 생성

    $issuer = G5_API_URL;
    $audience = G5_JWT_AUDIENCE;
    $issuedAt = time(); //발행시간
    $notBefore = $issuedAt; // seconds 즉시사용으로 처리, 서버에서 지연설정 있을시 설정
    $expirationTime = $issuedAt + (60 * G5_JWT_ACCESS_MTIME); //유효시간 약 15분 정도 설정

    $payload = [
        "mb_id" => $mb['mb_id'],
        "iss" => $issuer,
        "aud" => $audience,
        "iat" => $issuedAt,
        "nbf" => $notBefore,
        "exp" => $expirationTime
    ];

    $AccessToken = $jwt->encode($payload, G5_JWT_ACCESS_TOKEN_KEY, "HS256");

    // JWT Refresh Token 생성
    // 자동로그인시 refresh token 기간 1개월로 설정
   
     $reexpirationTime = $issuedAt + (60 * 60 * 24 * G5_JWT_RERESH_DATE);
     $uuid = gen_uuid_v4();
     $redata = array(

         'id' => $uuid,
         'iat' => $issuedAt,
         'exp' => $reexpirationTime

     );

     $retoken = $jwt->encode($redata, G5_JWT_REFESH_TOKEN_KEY, 'HS256');


     $agent = $_SERVER['HTTP_USER_AGENT'];

     //로그인 또는 최초 회원 등록시 refresh token 발행하여 id 클라이언트로 전달
     //Refresh token db 저장
     set_refresh_token($retoken, $mb['mb_id'], $uuid, $agent);
     



    // 포인트 체크
    if($config['cf_use_point']) {
        $sum_point = get_point_sum($mb['mb_id']);

        $sql= " update {$g5['member_table']} set mb_point = '$sum_point' where mb_id = '{$mb['mb_id']}' ";
        sql_query($sql);
    }
    //소셜 로그인 추가
    if(function_exists('social_login_success_after')){
        // 로그인 성공시 소셜 데이터를 기존의 데이터와 비교하여 바뀐 부분이 있으면 업데이트 합니다.
        $link = social_login_success_after($mb, $link);
        social_login_session_clear(1);
    }

    //영카트 회원 장바구니 처리
    if(function_exists('set_cart_id')){
        $member = $mb;

        // 보관기간이 지난 상품 삭제
        cart_item_clean();
        set_cart_id('');
        $s_cart_id = get_session('ss_cart_id');
        // 선택필드 초기화
        $sql = " update {$g5['g5_shop_cart_table']} set ct_select = '0' where od_id = '$s_cart_id' ";
        sql_query($sql);
    }

    run_event('member_login_check', $mb, $link, $is_social_login);

    // 관리자로 로그인시 DATA 폴더의 쓰기 권한이 있는지 체크합니다. 쓰기 권한이 없으면 로그인을 못합니다.
    if( is_admin($mb['mb_id']) && is_dir(G5_DATA_PATH.'/tmp/') ){
        $tmp_data_file = G5_DATA_PATH.'/tmp/tmp-write-test-'.time();
        $tmp_data_check = @fopen($tmp_data_file, 'w');
        if($tmp_data_check){
            if(! @fwrite($tmp_data_check, G5_URL)){
                $tmp_data_check = false;
            }
        }
        if (is_resource($tmp_data_check)) @fclose($tmp_data_check);
        @unlink($tmp_data_file);

        if(! $tmp_data_check){
            json_return('',200,'00002',"data 폴더에 쓰기권한이 없거나 또는 웹하드 용량이 없는 경우<br>로그인을 못할수도 있으니, 용량 체크 및 쓰기 권한을 확인해 주세요.");
        }
    }


    // Return the JWT token

    // 클라이언트에 저장할 최소한의 회원 정보 넘겨주기
   $mb_info = get_member($mb['mb_id'],"mb_id,mb_name,mb_nick,mb_level,mb_point,mb_memo_cnt,mb_scrap_cnt");
   //암호화
   //$retoken_enc = new str_encrypt();
   $retoken = encrypt($retoken);

    json_return([
        "accessToken" => $AccessToken,
        "refreshToken" => $retoken,
        "mb" => $mb_info
    ], 200, '00000','로그인 성공');

}

// 소셜로그인
function SocialLogin(){

}


// 로그인용 보안 문자 요청
function SmsLoginRequest(){


}

// 문자요청 로그인
function SmsLogin(){


}




//1차 보안 요청 : 문자 수신
function FirstAuthSendSms(){

}

//1차 보안 요청 확인 : 수신된 보안코드 인증
function FirstAuthSendSmsRequest(){

}

// 2차 보안 확인 : 비밀번호
function SecoundAuth(){

}




// 로그아웃 
function Logout($data) {
    // Destroy the session
    

    // Redirect to the login page
    // header('Location: /login.php');
    // Return the JWT token
    json_return([
        "access_token" => $jwt,
        "refresh_token" => $refresh_token
    ], 200, '00000','로그아웃 성공');

}