<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

///api/lib/jwt.php 파일을 읽어옴
include_once G5_API_PATH. '/lib/jwt.php';


// Function to handle a login request
function Index() {
    
  
    $jwt = new JWT("ES256");

    // Get the request data
    $requestData = json_decode(file_get_contents('php://input'), true);

    $retoken = $requestData['refreshToken'];
    //$retoken = isset($_POST['refreshToken']) ? trim($_POST['refreshToken']) : '';

    //토큰 복호화
    $retoken = decrypt($retoken);

    //jwt 사용하여 회원 정보 승인
    $jwt = new JWT();
    $JwtsecretKey = G5_JWT_ACCESS_TOKEN_KEY;
    $JwtresecretKey = G5_JWT_REFESH_TOKEN_KEY;



    if (!$retoken) {
        //토큰 유무
     

        json_return($retoken, 203, '00102','토큰이 없습니다.');
    
   
    } else {
        $algs[] = "HS256";
        $tinfo = $jwt->decode($retoken, $JwtresecretKey, $algs);

        //회원 상태값 불러와 jwt 변환후 cookie에 저장하기
   
        if (!$tinfo->id) {
            //암호 통과 유무
            
            json_return('', 203, '00202','토큰이 유효하지 않습니다.');

        } else {
            if ($tinfo->exp <= time()) {
                //만료시간 확인 
              
                json_return('', 203, '00302','토큰이 시간이 만료되었습니다.');
           
            } else {

                $tk = get_refresh_token($tinfo->id);
                //회원여부 검증
                if (!$tk['mb_id']) {

                 
                    json_return('', 203, '00402','회원이 존재하지 않습니다.');

                } else {

                    $agent = $_SERVER['HTTP_USER_AGENT'];


                    if ($tk['agent'] != $agent) {

                        // $this->output->set_status_header('203');
                        
                        json_return('', 203, '00502','접속환경이 같지 않습니다.');
        
                    } else {



                        $result['user'] = get_member($tk['mb_id']);
                       
                        if (!$result['user']['mb_id']) {
                            json_return('', 203, '00601','회원 권한이 없습니다.');
                        
                        } else {
                            //accesstoken
                            $issuer = G5_API_URL;
                            $audience = G5_JWT_AUDIENCE;
                            $issuedAt = time(); //발행시간
                            $notBefore = $issuedAt; // seconds 즉시사용으로 처리, 서버에서 지연설정 있을시 설정
                            $expirationTime = $issuedAt + (60 * G5_JWT_ACCESS_MTIME); //유효시간 약 15분 정도 설정
                        
                            $payload = array(

                                'mb_id' => $result['user']['mb_id'],
                                "iss" => $issuer,
                                "aud" => $audience,
                                "iat" => $issuedAt,
                                "nbf" => $notBefore,
                                "exp" => $expirationTime

                            );

                            $AccessToken  = $jwt->encode($payload, $JwtsecretKey, 'HS256');



                            //refreshtoken
                            //변경 등록 전체 기간중 중간 시기에 refresh token 재발급
                            $half = (60 * 60 * 24 * G5_JWT_RERESH_DATE) / 2;

                            if ($tinfo->exp <= (time() + $half)) {

                                $reexpirationTime = $issuedAt + (60 * 60 * 24 * G5_JWT_RERESH_DATE);
                                $uuid = gen_uuid_v4();
                                $tdata = array(

                                    'id' => $uuid,
                                    'iat' => $issuedAt,
                                    'exp' => $reexpirationTime

                                );

                                $retoken = $jwt->encode($tdata, $JwtresecretKey, 'HS256');

                                $agent = $_SERVER['HTTP_USER_AGENT'];

                                //다시 등록
                                set_refresh_token($retoken, $result['user']['mb_id'], $uuid, $agent);

                                //암호화
                              
                             

                               
                            }


                        }
                    }
                }
            }
        }
    }



    $mb_info = get_member($result['user']['mb_id'],"mb_id,mb_name,mb_nick,mb_level,mb_point,mb_memo_cnt,mb_scrap_cnt");
   
    //토큰 암호화
    $retoken = encrypt($retoken);
    json_return([
        "newAccessToken" => $AccessToken,
        "newRefreshToken" => $retoken,
        "mb" => $mb_info
    ], 200, '00000','재발행 성공');

}