import axios from 'axios';
import { setInterceptors } from './interceptors';
import { ProgressStatus, ProgressRate } from '$lib/store/updownprogress';
import { mb } from '$lib/store/mbstore';
let config_width_file = {
	baseURL: import.meta.env.VITE_API_ENDPOINT,
	timeout: 30000,
	withCredentials: true,
	//파일 업로드 진행율 표시
	onUploadProgress: function (progressEvent:any) {
		// Do whatever you want with the native progress event

		var percentCompleted = Math.round((progressEvent.loaded * 100) / progressEvent.total);
		//업로드 진행사항 보여주기
		ProgressStatus.set('upload');
		ProgressRate.update((n) => (n = percentCompleted));
	},

	// `onDownloadProgress` allows handling of progress events for downloads
	// browser only
	onDownloadProgress: function (progressEvent:any) {
		// Do whatever you want with the native progress event
		var percentCompleted = Math.round((progressEvent.loaded * 100) / progressEvent.total);
		//다운로드 진행사항 보여주기
		ProgressStatus.set('download');

		ProgressRate.update((n) => (n = percentCompleted));
	}
};

let config = {
	baseURL: import.meta.env.VITE_API_ENDPOINT,
	timeout: 30000,
	withCredentials: true
};

function createInstance() {
	const instance = axios.create(config);
	//test token
	//let at = localStorage.getItem("accessToken");
	//instance.defaults.headers.common.Authorization = `Bearer ${at}`;

	return instance;
}
export const instance = createInstance();

function createInstanceWithAuth() {
	const instance = axios.create(config);
	let result = instance;
	mb.useLocalStorage();
	mb.subscribe((value) => {
		if (value.mb_id) result = setInterceptors(instance);
	});
	return result;
}
export const instanceWithAuth = createInstanceWithAuth();

function createInstanceWithAuthFile() {
	const instance = axios.create(config_width_file);

	return setInterceptors(instance);
}
export const instanceWithAuthFile = createInstanceWithAuthFile();
