// 숫자 천단위 콤마
export const AddCommaNum = (inputNumber: number) => {
	let formetedNumber = Number(inputNumber)
		.toFixed(2)
		.replace(/\d(?=(\d{3})+\.)/g, '$&,');
	let splitArray = formetedNumber.split('.');
	if (splitArray.length > 1) {
		formetedNumber = splitArray[0];
	}
	return formetedNumber;
};

export const dateFormat = (date: string) =>
	new Date(date).toISOString().substring(2, 10).replace(/-/gi, '.');

const createDoubble = (num: number) => (num < 9 ? '0' + num : num);

export const dateFormatTime = (date: string) =>
	`${createDoubble(new Date(date).getHours())}:${createDoubble(new Date(date).getMinutes())}`;

//d-day 계산
export const dDay = (date: string) => {
	let today = new Date();
	let dDay = new Date(date);
	let gap = dDay.getTime() - today.getTime();
	let result = Math.ceil(gap / (1000 * 60 * 60 * 24));
	return result;
};

export const phoneNumber = (value: string) => {
	if (!value) {
		return '';
	}

	value = value.replace(/[^0-9]/g, '');

	let result = [];
	let restNumber = '';

	// 지역번호와 나머지 번호로 나누기
	if (value.startsWith('02')) {
		// 서울 02 지역번호
		result.push(value.substring(0, 2));
		restNumber = value.substring(2);
	} else if (value.startsWith('1')) {
		// 지역 번호가 없는 경우
		// 1xxx-yyyy
		restNumber = value;
	} else {
		// 나머지 3자리 지역번호
		// 0xx-yyyy-zzzz
		result.push(value.substring(0, 3));
		restNumber = value.substring(3);
	}

	if (restNumber.length === 7) {
		// 7자리만 남았을 때는 xxx-yyyy
		result.push(restNumber.substring(0, 3));
		result.push(restNumber.substring(3));
	} else {
		result.push(restNumber.substring(0, 4));
		result.push(restNumber.substring(4));
	}

	return result.filter((val) => val).join('-');
};
