﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Drawing;
using System.Xml;
using System.IO;

namespace Flash
{
    public class FlashFileUploadHandler : IHttpHandler
    {
        private const string FILEROOT = "/Data/";
        private const string EMPTYSTATUS = "<result><status>0</status><message>No files selected</message></result>";

        public FlashFileUploadHandler()
        {
        }

        public bool IsReusable
        {
            get { return true; }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="context"></param>
        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/xml";

            System.Threading.Thread.Sleep(1000);

            //check parameter
            string strBoardID = context.Request.Form["BoardID"] == null ? "1" : context.Request.Form["BoardID"];

            if (context.Request.Files.Count > 0)
            {
                // get the current file
                HttpPostedFile file = context.Request.Files[0];
                // see if there was a file and content length
                if (file != null && file.ContentLength > 0)
                {
                    //see request header. flash client Content-Type , always application/octet-stream
                    //so can't check image mine type
                    //but flash FileReference auto check this by fileFilter
                    //try upload fake image file. u will see alert
                    //try upload 0 byte file then flash I.O error invoked.

                    //string strMime = file.ContentType;
                    //if (strMime != "image/pjpeg" && strMime != "image/gif" && strMime != "image/x-png")
                    //{

                    //    return;
                    //}

                    string strUploadDirPath = FILEROOT + strBoardID + "/";
                    
                    string strPhysicalPath = context.Server.MapPath(strUploadDirPath);

                    DirectoryInfo dir = new DirectoryInfo(strPhysicalPath);
                    if (!dir.Exists)
                        dir.Create();

                    string strFileName = Path.GetFileName(file.FileName.Trim());
                    string strUniqueFileName = GetUniqueFileName(strPhysicalPath, strFileName);

                    file.SaveAs(strPhysicalPath + strUniqueFileName);

                    string strGuid = Guid.NewGuid().ToString().Substring(0, 8) + DateTime.Now.Millisecond;

                    //required html editor for image resize.
                    string[] strImageSize = GetImageSize(strPhysicalPath + strUniqueFileName);
                    if (strImageSize.Length != 2)
                    {
                        strImageSize[0] = "500";
                        strImageSize[1] = "400";
                    }

                    //we use flash XML class. so do not need xml document type. just like below...
                    StringBuilder sb = new StringBuilder();

                    sb.Append("<result><status>1</status><message>Upload Completed</message>");
                    sb.Append("<id>" + strGuid + "</id>");
                    sb.Append("<path>" + strBoardID + "/" + strUniqueFileName + "</path>");
                    sb.Append("<width>" + strImageSize[0] + "</width>");
                    sb.Append("<height>" + strImageSize[1] + "</height>");
                    sb.Append("</result>");

                    context.Response.Write(sb.ToString());
                }
            }
            else
            {
                context.Response.Write(EMPTYSTATUS);
            }

            context.Response.Flush();
            context.Response.End();
        }

        private string[] GetImageSize(string pUrl)
        {
            string[] strImageSize = new string[2];
            using (Bitmap bmp = new Bitmap(pUrl))
            {
                strImageSize[0] = bmp.Width.ToString();
                strImageSize[1] = bmp.Height.ToString();
            }

            return strImageSize;
        }

        private string GetUniqueFileName(string pDirPath, string pFileName)
        {
            int iIndexOfDot = pFileName.LastIndexOf(".");
            string strName  = pFileName.Substring(0, iIndexOfDot);
            string strExt   = pFileName.Substring(iIndexOfDot + 1);

            bool bExit = true;
            int iFileCount = 0;

            while (bExit)
            {
                if (File.Exists(Path.Combine(pDirPath, pFileName)))
                {
                    iFileCount++;
                    pFileName = strName + "(" + iFileCount + ")." + strExt;
                }
                else
                    bExit = false;
            }
            return pFileName;
        }
    }
}
