"use strict"

/**
 * @author EVENING - JJB
 * @param obj
 * @constructor
 */
function Box(obj){
    this.uid            = new Date().getTime();
    this.boxContainer 	= null;
    this.boxOverwrap	= null;
    this.boxBody		= null;
    this.boxClose		= null;
    this.boxImage		= null;
    this.boxIframe		= null;
    this.boxHtml		= null;
    this.boxLoading		= null;
    this.boxTimer		= null;

    this.contentsType	= (typeof obj == 'object' && typeof obj.contentsType != 'undefined')? obj.contentsType : 'html';
    this.boxOpacity		= 0;
    this.boxSpeed		= (typeof obj == 'object' && typeof obj.boxSpeed != 'undefined')? obj.boxSpeed : 50;
    this.boxEffect		= (typeof obj == 'object' && typeof obj.boxEffect != 'undefined')? obj.boxEffect : 'fade';
    this.isOverlay		= (typeof obj == 'object' && typeof obj.isOverlay != 'undefined')? obj.isOverlay : true;
    this.boxZoom		= (typeof obj == 'object' && typeof obj.boxZoom != 'undefined')? obj.boxZoom : 100;
    this.isHideByClick	= (typeof obj == 'object' && typeof obj.isHideByClick != 'undefined')? obj.isHideByClick : true;
    this.isHideByDbClick	= (typeof obj == 'object' && typeof obj.isHideByDbClick != 'undefined')? obj.isHideByDbClick : true;
    this.boxLeft		= 50; // left: 50%;
    this.boxTop			= 50; // top: 50%;
    this.boxWidth		= (typeof obj == 'object' && typeof obj.boxWidth == 'number')? obj.boxWidth : null;
    this.boxHeight		= (typeof obj == 'object' && typeof obj.boxHeight == 'number')? obj.boxHeight : null;

    this.boxContents	= (typeof obj == 'object' && typeof obj.boxContents != 'undefined')? obj.boxContents : null;

    this.onclose	    = (typeof obj == 'object' && typeof obj.onclose == 'function')? obj.onclose : null;
    this.onload	        = (typeof obj == 'object' && typeof obj.onload == 'function')? obj.onload : null;

    this.isShowLoading = (typeof obj == 'object' && typeof obj.isShowLoading != 'undefined')? obj.isShowLoading : true;

    this.isShowCloseBtn = (typeof obj == 'object' && typeof obj.isShowCloseBtn != 'undefined')? obj.isShowCloseBtn : false;

    /*this.closeBox();*/
}
Box.prototype.closeBox = function(){
    if(this.onclose != null) {
        this.onclose();
    }
    if(this.boxContainer){
        clearInterval(this.boxTimer);
        document.body.removeChild(this.boxContainer);
        document.body.style.removeProperty('overflow');
    }
};
Box.prototype.hideLoading = function(){
    this.boxLoading.style.display = "none";
};
Box.prototype.clientSize = function(){
    var width 	= window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
    var height 	= window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;
    return {width: width, height: height};
};
Box.prototype.zIndexMax = function(){
    var elems 	= document.body.getElementsByTagName("*");
    var largest = null;
    var check 	= 0;
    for(var i=0; i<elems.length; i++){
        if(elems[i].style.zIndex > check){
            check 	= elems[i].style.zIndex;
            largest = elems[i];
        }
    }
    return check;
};
Box.prototype.showBox = function(){
    var self = this;
    self.hideLoading();
    switch (self.boxEffect){
        case 'fade':
            self.boxOpacity = 0;
            self.boxBody.style.opacity = self.boxOpacity;
            self.boxTimer = setInterval(self.showBoxByFade, self.boxSpeed, self);
            break;
        case 'left_right':
            self.boxOpacity = 1;
            self.boxBody.style.opacity = self.boxOpacity;
            self.boxLeft = -50;
            self.boxBody.style.left = self.boxLeft + "%";
            self.boxTimer = setInterval(self.showBoxByLeftRight, self.boxSpeed, self);
            break;
        case 'right_left':
            self.boxOpacity = 1;
            self.boxBody.style.opacity = self.boxOpacity;
            self.boxLeft = 50;
            self.boxBody.style.left = self.boxLeft + '%';
            self.boxTimer = setInterval(self.showBoxByRightLeft, self.boxSpeed, self);
            break;
        case 'top_bottom':
            self.boxOpacity = 1;
            self.boxBody.style.opacity = self.boxOpacity;
            self.boxTop = -50;
            self.boxBody.style.top = self.boxTop + '%';
            self.boxTimer = setInterval(self.showBoxByTopBottom, self.boxSpeed, self);
            break;
        case 'bottom_top':
            self.boxOpacity = 1;
            self.boxBody.style.opacity = self.boxOpacity;
            self.boxTop = 50;
            self.boxBody.style.top = self.boxTop + '%';
            self.boxTimer = setInterval(self.showBoxByBottomTop, self.boxSpeed, self);
            break;
        default:
            self.boxTimer = setInterval(self.showBoxByFade, self.boxSpeed, self);
    }

    if(this.onload != null) {
        this.onload();
    }
};
Box.prototype.showBoxByFade = function(self){
    if(self.boxBody.style.opacity >= 1){
        clearInterval(self.boxTimer);
        self.boxOpacity = 1;
    }
    else{
        self.boxOpacity += 0.1;
    }
    self.boxBody.style.opacity = self.boxOpacity;
};
Box.prototype.showBoxByLeftRight = function(self){
    if(self.boxLeft >= 0){
        clearInterval(self.boxTimer);
        self.boxLeft = 0;
    }
    else{
        self.boxLeft += 10;
    }
    self.boxBody.style.left = self.boxLeft + "%";
};
Box.prototype.showBoxByRightLeft = function(self){
    if(self.boxLeft <= 0){
        clearInterval(self.boxTimer);
        self.boxLeft = 0;
    }
    else{
        self.boxLeft -= 10;
    }
    self.boxBody.style.left = self.boxLeft + "%";
};
Box.prototype.showBoxByTopBottom = function(self){
    if(self.boxTop >= 0){
        clearInterval(self.boxTimer);
        self.boxTop = 0;
    }
    else{
        self.boxTop += 10;
    }
    self.boxBody.style.top = self.boxTop + "%";
};
Box.prototype.showBoxByBottomTop = function(self){
    if(self.boxTop <= 0){
        clearInterval(self.boxTimer);
        self.boxTop = 0;
    }
    else{
        self.boxTop -= 10;
    }
    self.boxBody.style.top = self.boxTop + "%";
};
Box.prototype.addBoxEvent = function(){
    var self = this;
    if(self.isHideByClick === true){
        this.boxContainer.addEventListener('click', function(){
            self.closeBox();
        });
    }
    this.boxClose.addEventListener('click', function(){
        self.closeBox();
    });
    this.boxBody.addEventListener('click', function(event){
        //event.preventDefault();
        event.stopPropagation();
    });
    this.boxBody.addEventListener('dblclick', function(event){
        if(self.isHideByDbClick === true) {
            self.closeBox();
        }
    });
    this.boxBody.addEventListener('mouseover', function(event){
        self.boxClose.style.display = "inline";
    });
    this.boxBody.addEventListener('mouseout', function(event){
        if(self.isShowCloseBtn === false) {
            self.boxClose.style.display = "none";
        }
    });

    this.boxImage.addEventListener('load', function(event){
        self.originalWidth = self.boxWidth == null? self.boxImage.width : self.boxWidth;
        self.originalHeight = self.boxHeight == null? self.boxImage.height : self.boxHeight;

        var size = self.adjustSize();
        self.boxImageResize(size);
        self.boxBodyResize(size);
        self.boxCloseReposition(size);

        self.showBox();
    });

    this.boxIframe.addEventListener('load', function(event){
        var ifr = self.boxIframe.contentWindow.document || self.boxIframe.contentDocument;
        ifr.onreadystatechange = function () {
            console.log(ifr.readyState);
            if(ifr.readyState === 'complete') {
                clearInterval(interval);
                self.originalWidth = self.boxWidth == null? self.clientSize().width : self.boxWidth;
                self.originalHeight = self.boxHeight == null? self.clientSize().height : self.boxHeight;

                var size = self.adjustSize();
                self.boxIframeResize(size);
                self.boxBodyResize(size);
                self.boxCloseReposition(size);

                self.showBox();
            }
        };
        var interval = setInterval(ifr.onreadystatechange, 50);
    });

    window.addEventListener('resize', function(event){
        var size = self.adjustSize();
        self.boxImageResize(size);
        self.boxIframeResize(size);
        self.boxHtmlResize(size);
        self.boxBodyResize(size);
        self.boxCloseReposition(size);
    });
};
Box.prototype.boxBodyResize = function(size){
    var self = this;
    self.boxBody.style.width 	= size.width + "px";
    self.boxBody.style.height 	= size.height + "px";
};
Box.prototype.boxImageResize = function(size){
    var self = this;
    self.boxImage.style.width 	= size.width + "px";
    self.boxImage.style.height 	= size.height + "px";
};
Box.prototype.boxIframeResize = function(size){
    var self = this;
    self.boxIframe.style.width 	= size.width + "px";
    self.boxIframe.style.height = size.height + "px";
};
Box.prototype.boxHtmlResize = function(size){
    var self = this;
    self.boxHtml.style.width 	= size.width + "px";
    self.boxHtml.style.height 	= size.height + "px";
};
Box.prototype.boxCloseReposition = function(size){
    var self = this;
    /*self.boxClose.style.top = (self.clientSize().height <= size.height)?  (size.height - self.clientSize().height)/2 + "px" : "15px";
    self.boxClose.style.right = (self.clientSize().width <= size.width)?  (size.width - self.clientSize().width)/2 + "px" : "15px";*/
};
Box.prototype.adjustSize = function() {
    var self = this;
    var w = 0, h = 0, contents_ratio = 0, window_ratio = 0, ratio_w = 0, ratio_h = 0;

    contents_ratio = self.originalWidth / self.originalHeight;
    window_ratio = self.clientSize().width / self.clientSize().height;
    ratio_w = self.originalWidth / self.clientSize().width;
    ratio_h = self.originalHeight / self.clientSize().height;

    if (ratio_w < 1 && ratio_h < 1) {
        w = self.originalWidth;
        h = self.originalHeight;
    }
    else if (ratio_w >= 1 && ratio_h >= 1) {
        if (ratio_w >= ratio_h) {
            w = self.clientSize().width;
            h = w / contents_ratio;
        }
        else {
            h = self.clientSize().height;
            w = contents_ratio * h;
        }
    }
    else if (ratio_w >= 1 && ratio_h < 1) {
        w = self.clientSize().width;
        h = w / contents_ratio;
    }
    else if (ratio_w < 1 && ratio_h >= 1) {
        h = self.clientSize().height;
        w = contents_ratio * h;
    }
    else {
        w = self.originalWidth;
        h = self.originalHeight;
    }
    return {width: w * (self.boxZoom / 100), height: h * (self.boxZoom / 100)};
};
Box.prototype.createBox = function(){
    var box_container = document.createElement('div');
    box_container.id = "box_container_" + this.uid;
    box_container.className = 'box_container';
    var box_overwrap = document.createElement('div');
    box_overwrap.id = "box_overwrap_" + this.uid;
    box_overwrap.className = 'box_overwrap';
    var box_body = document.createElement('div');
    box_body.id = "box_body_" + this.uid;
    box_body.className = 'box_body';

    var box_close = document.createElement('a');
    box_close.id = "box_close_" + this.uid;
    box_close.className = 'box_close';
    box_close.innerHTML = "x";
    var box_img = document.createElement('img');
    box_img.id = "box_img_" + this.uid;
    box_img.className = 'box_img';
    var box_loading = document.createElement('span');
    box_loading.id = "box_loading_" + this.uid;
    box_loading.className = 'box_loading';
    box_loading.innerHTML = "<span class='box_spinner'></span>";

    var box_iframe = document.createElement('iframe');
    box_iframe.id = "box_iframe_" + this.uid;
    box_iframe.className = 'box_iframe';
    box_iframe.setAttribute('scrolling', 'no');
    box_iframe.setAttribute('frameborder', '0');

    var box_html = document.createElement('div');
    box_html.id = "box_html_" + this.uid;
    box_html.className = 'box_html';

    box_body.appendChild(box_close);
    box_container.appendChild(box_overwrap);
    box_container.appendChild(box_body);
    if(this.isShowLoading === true) {
        box_container.appendChild(box_loading);
        box_loading.style.display = 'block';
    }

    this.boxContainer 	= box_container;//document.getElementById('box_container');
    this.boxOverwrap	= box_overwrap; //document.getElementById('box_overwrap');
    this.boxBody		= box_body; //document.getElementById('box_body');
    this.boxClose 		= box_close; //document.getElementById('box_close');
    this.boxImage		= box_img; //document.getElementById('box_img');
    this.boxLoading		= box_loading; //document.getElementById('box_loading');
    this.boxIframe 		= box_iframe; //document.getElementById('box_iframe');
    this.boxHtml		= box_html; //document.getElementById('box_html');

    if(this.isShowCloseBtn === true) {
        this.boxClose.style.display = 'inline';
    } else {
        this.boxClose.style.display = 'none';
    }

    this.appendBox();
};
Box.prototype.appendBox = function(){
    this.boxOverwrap.style.zIndex 	= this.zIndexMax() + 1;
    this.boxBody.style.zIndex 		= this.zIndexMax() + 2;
    this.boxLoading.style.zIndex	= this.zIndexMax() + 3;

    this.boxContainer.style.top = window.scrollY + 'px';
    this.boxContainer.style.left = window.scrollX + 'px';

    document.body.appendChild(this.boxContainer);
    document.body.style.overflow = 'hidden';

    if(this.isOverlay === false){
        this.boxOverwrap.style.opacity = 0;
    }
    this.boxContainer.style.display = "flex";
};
Box.prototype.loadImage = function(){
    var self = this;
    self.boxBody.appendChild(self.boxImage);
    self.boxImage.src = self.boxContents;
};
Box.prototype.loadIframe = function(){
    var self = this;
    self.boxBody.appendChild(self.boxIframe);
    self.boxIframe.src = self.boxContents;
};
Box.prototype.loadHtml	= function(){
    var self = this;
    self.boxBody.appendChild(self.boxHtml);
    self.boxHtml.innerHTML = self.boxContents;

    self.originalWidth 	= (self.boxWidth == null)? self.clientSize().width : self.boxWidth;
    self.originalHeight	= (self.boxHeight == null)? self.clientSize().height : self.boxHeight;

    var size = self.adjustSize();
    self.boxHtmlResize(size);
    self.boxBodyResize(size);
    self.boxCloseReposition(size);
    self.showBox();
};
Box.prototype.loadBox = function(){
    var self = this;

    self.createBox();

    self.addBoxEvent();

    switch(self.contentsType){
        case 'image':
            self.loadImage();
            break;
        case 'iframe':
            self.loadIframe();
            break;
        case 'html':
            self.loadHtml();
            break;
    }
};