<?php
/**
 * Track class
 * It should be changed according to the specific operation of the application.
 *
 * @package app
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Track
{
    public static function errors($msg)
    {
        $request = self::request();
        $message = $msg.PHP_EOL.$request.PHP_EOL;
        $root = gURL('protected').DS.'log';
        FileUtils::makeDir($root);
        $file = $root.DS.date('Y-m-d').'_errors'.'.txt';
        Tracer::save($file, $message);
    }

    /**
     * Save request details to local file.
     * Generally doesn't run by traceable['active'] = false in config.json.
     * If set true, then write all request into local file.
     */
	public static function access()
    {
        if(!isset(CONFIG['traceable']) || !isset(CONFIG['traceable']['active']) ||  CONFIG['traceable']['active'] !== true) return;

        $url = Filter::decode_url($_SERVER["REQUEST_URI"]);
        if(self::ignoredURL($url)) return;

        $ip = PhpClient::getClientIp();
        if(self::ignoredIP($ip)) return;

        $msg = self::request();

        $root = gURL('protected').DS.'log';
        FileUtils::makeDir($root);
        $file = $root.DS.date('Y-m-d').'_access'.'.txt';
        Tracer::save($file, $msg);
    }

    private static function request()
    {
        $url = Filter::decode_url($_SERVER["REQUEST_URI"]);
        $ip = PhpClient::getClientIp();
        $datetime = date('Y-m-d H:i:s');
        $method = PhpClient::requestMethod();
        $msg = $datetime.' '.$ip.' '.$method.' '.$url;
        $msg .= PHP_EOL;

        $data['GET'] = $_GET;
        $data['POST'] = $_POST;
        $data['FILES'] = $_FILES;
        $msg .= json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        $msg .= PHP_EOL;
        return $msg;
    }

    private static function ignoredURL($url)
    {
        $_list = (!isset(CONFIG['traceable']) || !isset(CONFIG['traceable']['ignoredURL']))? array() : CONFIG['traceable']['ignoredURL'];

        $flag = false;

        foreach ($_list as $item) {
            if(strpos($url, $item) !== false) {
                $flag = true;
                break;
            }
        }

        return $flag;
    }

    private static function ignoredIP($ip)
    {
        $_list = (!isset(CONFIG['traceable']) || !isset(CONFIG['traceable']['ignoredIP']))? array() : CONFIG['traceable']['ignoredIP'];

        $flag = false;

        foreach ($_list as $item) {
            if(strpos($ip, $item) !== false) {
                $flag = true;
                break;
            }
        }

        return $flag;
    }
}