<?php
/**
 * Cache base class
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Cache
{
	protected $_original;
	protected $_path;
	protected $_name;

    /**
     * Cache constructor.
     * @param $path
     * @param $clientid 요청말단전용으로 캐쉬파일을 창조하려는 경우 이 값을 설정한다.
     */
	public function __construct($path, $clientid=NULL)
	{
        $this->setOriginal($path);
        $this->setName($clientid);
        $this->setPath();
        //$this->clear();
	}

	public function setOriginal($path)
    {
        $this->_original = $path;
    }
    public function getOriginal()
    {
        return $this->_original;
    }

	public function setName($clientid=NULL)
    {
        clearstatcache();
        $this->_name = md5($this->_original).".".@filesize($this->_original).".".@filemtime($this->_original);
        if(!empty($clientid)) {
            $this->_name .= ".".$clientid;
        }
    }
    public function getName()
    {
        return $this->_name;
    }

    public function setPath()
    {
        $this->_path = gURL('cache').DS.$this->getName();
    }
    public function getPath()
    {
        return $this->_path;
    }

    public function clear()
    {
        $path = $this->getPath();
        if(!$this->check()) {
            $split = md5($this->getOriginal());
            $files = FileUtils::findAllFiles(FileUtils::mb_pathinfo($path, PATHINFO_DIRNAME));
            foreach ($files as $file) {
                if(strrpos($file, $split) !== false) {
                    @unlink($file);
                }
            }
        }
    }

    public function write($contents)
    {
        /*$handle = fopen($this->_path, 'w');
        fwrite($handle, $contents);
        fclose($handle);*/
        @file_put_contents($this->getPath(), $contents);
    }

    public function check()
    {
        if(file_exists($this->getPath())) return true;
        return false;
    }

    public function get()
    {
        if($this->check()) {
            /*$handle = fopen($this->_path, "rb");
            $contents = fread($handle, filesize($this->_path));
            fclose($handle);*/
            $contents = @file_get_contents($this->getPath());
            return $contents;
        }
        return '';
    }

    public function delete()
    {
        if($this->check()) {
            @unlink($this->getPath());
        }
    }
}