<?php
/**
 * Config base class
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Config
{
    private static $_routes = null;
    private static $_db = null;
    private static $_namespace = null;


	public static function routes()
    {
        if(!is_array(self::$_routes)) {
            self::$_routes = require gURL('config') . DS . 'route.config.php';
        }
        return self::$_routes;
    }

    public static function db()
    {
        if(!is_array(self::$_db)) {
            self::$_db = require gURL('config') . DS . 'db.config.php';
        }
        return self::$_db;
    }

    public static function names()
    {
        if(!is_array(self::$_namespace)) {
            self::$_namespace = require gURL('config') . DS . 'namespace.config.php';
        }
        return self::$_namespace;
    }
}