<?php
/**
 * Controller base class
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Controller
{
	protected $_model;
	protected $_controller;
	protected $_action;
	protected $_view;
	
	public function __construct()
	{
		$this->_controller = ucwords(__CLASS__);
		$this->_action = null;
		$this->_model = null;
        $this->_view = null;
	}
	
	protected function _setModel($val)
	{
        $instance = Loader::model($val);
        return $this->_model = $instance;
	}

    /**
     * For example, call as _setView('home/index')
     * then find a view file at gURL('views').DS.'home/index.php';
     * See gURL('views') at Global.php
     * @param $val
     * @return View
     * @throws Exception
     */
	protected function _setView($val)
	{
        $instance = Loader::view($val);
	    return $this->_view = $instance;
	}

    /**
     * @param $action Action's must be defined as 'public'.
     * @param $argument This doesn't really matter.
     * @throws ReflectionException
     */
	public function _runAction($action, $argument=null)
	{
	    $skip = array(
            '_runAction', '_beforeAction', '_afterAction',
            '_setModel', '_setView',
            '__construct',
            '__destruct',
            '__call',
            '__callStatic',
            '__get',
            '__set',
            '__isset',
            '__unset',
            '__sleep',
            '__wakeup',
            '__toString',
            '__invoke',
            '__set_state',
            '__clone'
        );
	    if(in_array($action, $skip) ) {
            throw new Exception('No permission to access the '.$action);
        }
        $this->_beforeAction();

        $this->_action = $action;

        $beforeAction = '_before'.ucwords($this->_action);
        $afterAction = '_after'.ucwords($this->_action);

        if(method_exists($this, $beforeAction))
        {
            //$this->{$beforeAction}();
            if(is_array($argument) && count($argument)>0) {
                @call_user_func_array(array($this, $beforeAction), $argument);
            } else {
                @call_user_func(array($this, $beforeAction));
            }
        }

        if(method_exists($this, $this->_action))
        {
            $permission = new ReflectionMethod(get_class($this), $this->_action);
            if($permission->isPublic() && !$permission->isConstructor()) {
                //$this->{$this->_action}();
                if(is_array($argument) && count($argument)>0) {
                    @call_user_func_array(array($this, $this->_action), $argument);
                } else {
                    @call_user_func(array($this, $this->_action));
                }
            } else {
                throw new Exception('Only can access public method: '.$action);
            }
        }
        else
        {
            throw new Exception('Not found method: '.$action);
        }

        if(method_exists($this, $afterAction))
        {
            //$this->{$afterAction}();
            if(is_array($argument) && count($argument)>0) {
                @call_user_func_array(array($this, $afterAction), $argument);
            } else {
                @call_user_func(array($this, $afterAction));
            }
        }

        $this->_afterAction();
	}
	/**
	 * The method have best top priority.
	 * It will be executed always before main controller.
     * Also it can be override by extended controller
	 */
	protected function _beforeAction()
	{
		// More logic
		return;
	}
	/**
	 * The method have super global scope.
	 * It will be executed always after main controller.
     * Also it can be override by extended controller
	 */
    protected function _afterAction()
	{
        // More logic
		return;
	}


}