<?php
/**
 * DB base class
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Db
{
	private static $db;
    private static $dsn;
    private static $config=null;
    public static $transIndex=0;
	
	public static function init()
	{
        self::$dsn = self::getDBLink();

        if(!self::$db) {
            if(!empty(self::$dsn)) {
                self::$db = new PDO(self::$dsn, DB_USER, DB_PASS);
                self::$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                self::$db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
            } else {
                throw new Exception(('Invalid connection: ' . self::$dsn));
            }
        }
        return self::$db;
	}

	public static function getDBLink()
    {
        $dsn = '';
        if(self::configUsedDBType() == 'mysql') {
            $dsn = self::mysql();
        }
        if(self::configUsedDBType() == 'pgsql') {
            $dsn = self::pgsql();
        }
        return $dsn;
    }

	public static function mysql()
    {
        if(self::usableMySQL()) {
            return $dsn = self::configLink('mysql');
        } else {
            return false;
        }
    }

    public static function pgsql()
    {
        if(self::usablePGSQL()) {
            return $dsn = self::configLink('pgsql');
        } else {
            return false;
        }
    }

    public static function initConfig()
    {
        if(!is_array(self::$config)) {
            self::$config = Config::db();
        }
    }

    public static function configLink($index)
    {
        self::initConfig();
        $config = self::$config['link'];
        return isset($config[$index])? $config[$index] : null;
    }

    public static function configUsedDBType()
    {
        self::initConfig();
        $config = self::$config['use'];
        return $config;
    }

    public static function usablePGSQL() {
        if(in_array('pgsql', PDO::getAvailableDrivers())) return true;
        return false;
    }
    public static function usableMySQL() {
        if(in_array('mysql', PDO::getAvailableDrivers())) return true;
        return false;
    }
    public static function usableMSSQL() {
        if(in_array('sqlsrv', PDO::getAvailableDrivers())) return true;
        return false;
    }

    /**
     * Get query prepared by bind param.
     * Replaces any parameter placeholders in a query with the value of that
     * parameter. Useful for debugging. Assumes anonymous parameters from
     * $params are are in the same order as specified in $query
     *
     * @param string $query The sql query with parameter placeholders
     * @param array $params The array of substitution parameters
     * @return string The interpolated query
     */
    public static function dumpQuery($query, $params=[]) {
        $keys = array();
        $values = $params;
        // build a regular expression for each parameter
        foreach ($params as $key => $value) {
            if (is_string($key)) {
                $keys[] = '/'.$key.'/';
            } else {
                $keys[] = '/[?]/';
            }

            if (is_string($value))
                $values[$key] = "'" . $value . "'";

            if (is_array($value))
                $values[$key] = "'" . implode("','", $value) . "'";

            if (is_null($value))
                $values[$key] = 'NULL';
        }

        $query = preg_replace($keys, $values, $query, 1, $count);

        return $query;
    }
}
