<?php
/**
 * Error Controller
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Errors
{
    public $code = 404;
    public $title = '';
    public $heading = '';
    public $message = '';
    public $page = '';

    public function __construct($code)
    {
        $this->page = gURL('errors').DS.'errors.php';
        $this->code = $code;
    }

    /**
     * Error Handler
     *
     * This function will send the error page directly to the
     * browser and exit.
     *
     */
    public function show()
    {
        $v = new View($this->page);
        $status = $v->setHttpStatusHeader($this->code);

        if($this->title=='') {
            $this->title = $status['code'].' '.$status['status'];
        }
        if($this->heading=='') {
            $this->heading = 'Status: '.$status['code'];
        }
        if($this->message=='') {
            $this->message = $status['status'];
        }

        $v->set('title', $this->title);
        $v->set('heading', $this->heading);
        $v->set('message', $this->message);
        $v->output();
        exit;
    }
}