<?php
require_once DOC_ROOT.DS.'protected'.DS.'base'.DS.'Global.php';

/**
 * EVENING STAR is my nick name on network. Shortly call as evening.
 * Bootstrap class
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Evening
{
    /**
     * Class autoload loader.
     * Support both namespace and non-namespace
     *
     * This method is provided to be invoked within an __autoload() magic method.
     * e.g. HomeController class is placed at /controllers/HomeController.php
     * !important class name is case-insensitive on Windows, HomeController, HoMeController both is find  at /controllers/homecontroller.php
     * @param string $class class name
     * @return boolean whether the class has been loaded successfully
     * @throws Exception
     */
    public static function autoload($class)
    {
        if(strpos($class, '\\') === false) { // non-namespace
            return self::classMapLoad($class);
        }
        else {
            return self::namespaceMapLoad($class);
        }

        return false;
    }

    private static function classMapLoad($class)
    {
        $map = $GLOBALS['CLASS_MAP'];
        foreach ($map as $value) {
            $root = $value;
            //$path = $root.DS.strtolower($class).'.php';
            $path = $root.DS.$class.'.php'; // For case-sensitive of UNIX
            if (file_exists($path))
            {
                require_once $path;
                return true;
            }
        }

        $path = str_replace(gURL('protected'), '', $path);
        throw new Exception("Cannot found: $class : $path");
    }

    private static function namespaceMapLoad($class)
    {
        $map = Config::names();

        $lastNsPos = strripos($class, '\\');
        $namespace = substr($class, 0, $lastNsPos);
        //$namespace = $path;
        $className = substr($class, $lastNsPos + 1);

        $defined = NULL;
        foreach ($map as $key=>$val) {
            if(strpos($namespace, $key) === 0) {
                $defined = str_replace($key, $val, $namespace);
            }
        }

        if($defined) {
            $path = str_replace('\\', DS, $defined).DS.$className.'.php';
        } else {
            $namespace = str_replace('\\', DS, $namespace);
            $path = gURL('protected').DS.$namespace.DS.$className.'.php'; //str_replace('_', DS, $className).'.php';
        }
        //$path = gURL('namespace').DS.$source;

        if (file_exists($path))
        {
            require_once $path;
            return true;
        }


        $path = str_replace(gURL('protected'), '', $path);
        throw new Exception("Cannot found: $class : $path");
    }


    /**
     * Boot loader
     */
    public static function run()
    {
        try {
            $_route = Router::prepare();

            $path       = $_route['path'];
            $controller = $_route['controller'];
            $action     = $_route['action'];
            $argument   = $_route['argument'];
            $callback   = $_route['callback'];

            Middleware::run();

            if(!empty($callback)) {
                if(is_array($argument) && count($argument)>0) {
                    @call_user_func_array($callback, $argument);
                } else {
                    @call_user_func($callback);
                }
            } else {
                $instance = Loader::controller($path.DS.$controller);
                $instance->_runAction($action, $argument);
            }
        }
        catch (Exception $e) {
            Middleware::errors($e);
        }
        catch (Throwable $t) {
            Middleware::errors($t);
        }
    }
}

spl_autoload_register(array('Evening','autoload'));