<?php
/**
 * Super global code.
 * In this code defined variable, method is global.
 * So u take care to define the method or variable to avoid define as duplicate name in other code.
 * Ideally naming of global methods and variable is to use prefix - 'g' as first character.
 * The defined methods can be accessed directly calling them.
 */

/**
 * Define is usable mod_rewrite module in Apache
 * Please find <LoadModule rewrite_module modules/mod_rewrite.so> at httpd.conf
 * If enabled MOD_RERITE = true or false
 */
define('MOD_REWRITE', gModRewrite());
define('BASE_URL', gGetBaseURL());

/**
 * Define core config about http request url and system directory structures.
 */
$GLOBALS['PATH_URL'] = array(
    /* For http URL */
    'root'=>   MOD_REWRITE? BASE_URL : BASE_URL.'/index.php',
    'public'=> BASE_URL.'/assets',
    'admin'=> BASE_URL.'/admin',

    /* For file path */
    'doc_root'=>    DOC_ROOT,
    'protected'=>   DOC_ROOT.DS."protected",
    'app'=>         DOC_ROOT.DS."protected".DS."app",
    'base'=>        DOC_ROOT.DS."protected".DS."base",
    'controllers'=> DOC_ROOT.DS."protected".DS."controllers",
    'models'=>      DOC_ROOT.DS."protected".DS."models",
    'views'=>       DOC_ROOT.DS."protected".DS."views",
    'utils'=>       DOC_ROOT.DS."protected".DS."utils",
    'config'=>      DOC_ROOT.DS."protected".DS."config",
    'namespace'=>   DOC_ROOT.DS."protected".DS."vendors",
    'cache'=>       DOC_ROOT.DS."protected".DS."cache",
    'language'=>    DOC_ROOT.DS."protected".DS."language",
    'errors'=>      DOC_ROOT.DS."protected".DS."errors",
    'assets'=>      DOC_ROOT.DS."assets",

    // Add more custom url
    'includes'=>    DOC_ROOT.DS."protected".DS."includes",
    'resource'=>    DOC_ROOT.DS."protected".DS."resource",
    'upload'=>      DOC_ROOT.DS."protected".DS."resource".DS."uploads",
);

/**
 * Class map
 * Dedicate directories for search the class files
 * Evening::autoload() refer to array.
 */
$GLOBALS['CLASS_MAP'] = array(
    $GLOBALS['PATH_URL']['base'],
    $GLOBALS['PATH_URL']['controllers'],
    $GLOBALS['PATH_URL']['models'],
    $GLOBALS['PATH_URL']['utils'],
    $GLOBALS['PATH_URL']['app'],
);

/**
 * Return root url of http request.
 * If framework source placed on DocumentRoot then value = '', otherwise set specify a relative path from DocumentRoot.
 * Example 1:
 * DocumentRoot = D:\www
 * EVENING source path = D:\www\evening
 * So, http request root URL of framework = http://localhost/evening
 * Then the base URL = /evening
 *
 * Example 2:
 * DocumentRoot = D:\www
 * EVENING source path = D:\www
 * So, http request root URL of framework = http://localhost
 * Then the base URL = ''
 */
function gGetBaseURL()
{
    $base = ''; // Default

    if(gIsCLI()) return $base;

    $base = substr($_SERVER['SCRIPT_NAME'], 0, strpos($_SERVER['SCRIPT_NAME'], basename($_SERVER['SCRIPT_FILENAME']))-1);
    $base = str_replace('\\', '/', $base);
    return $base;


    $app_root = str_replace(array('\\', '/'), DS, DOC_ROOT);
    $env_root = str_replace(array('\\', '/'), DS, $_SERVER['DOCUMENT_ROOT']);
    $arr = explode($env_root, $app_root);

    if(is_array($arr) && count($arr)==2) {
        $base = $arr[1];
    }
    $base = str_replace(DS, '/', $base);
    if(!empty($base)) {
        if(strpos($base, '/')!==0) {
            $base = '/'.$base;
        }
    }

    return $base;
}

function gModRewrite()
{
    if(gIsCLI() && !function_exists('apache_get_modules')) {
        return true;
    }
    return in_array('mod_rewrite', apache_get_modules());
}

function gIsCLI()
{
    return (PHP_SAPI === 'cli' OR defined('STDIN'));
}

function gURL($index)
{
    $path_url = $GLOBALS['PATH_URL'];
    return isset($path_url[$index])? $path_url[$index] : '';
}
function gURLE($index)
{
    echo gURL($index);
}



/************************************************************************************************/
/*******************************Global language function*****************************************/
// Must once call Language::import() before using the following functions.
/************************************************************************************************/

/**
 * @param $index Index in language array.
 * @param null $data Replace array
 * @return string
 */
function gText($index, $data=null)
{
    return Language::get($index, $data);
}

// echo text
function gTextE($index, $data=null)
{
    echo gText($index, $data);
}


function gLineCharacter()
{
    if(gIsCLI()) return PHP_EOL;
    return "<br>";
}

