<?php
/**
 * Language base class
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Language
{
    public static $config = null;
    public static $data = null;

    public static function import($lang='en')
    {
        if(self::$config!=$lang || !is_array(self::$data)) {
            self::$config = $lang;
            $user_lang = FileUtils::mb_pathinfo(trim(self::$config, " \t\n\r\0\x0B\x8\x1A/\\"), PATHINFO_FILENAME);
            $url = gURL('language').DS.$user_lang.'.php';
            if(file_exists($url)) {
                self::$data = require $url;
                return true;
            } else {
                return false;
            }
        }
        return true;
    }

    public static function get($index, $data=null)
    {
        $lang = self::$data;
        if(!isset($lang[$index])) {
            return '';
        }
        else {
            $text = $lang[$index];
            if(empty($data)) {
                return $text;
            }
            else {
                return self::replace($text, $data);
            }
        }
    }
    /**
     * Replace text with param
     * @param $text
     * @param $data array e.g. ['search'=>'replace'] '##search##' in $text replace to 'replace'
     * @return mixed
     */
    public static function replace($text, $data)
    {
        foreach ($data as $key=>$val) {
            $text = str_replace('##'.$key.'##', $val, $text);
        }
        return $text;
    }
}