<?php
/**
 * Loader base class
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Loader
{
    public static function loadFile($filePath)
    {
        if(!file_exists($filePath)) {
            $tmp = explode('protected', $filePath);
            return 'File not exist: '.(isset($tmp[1])? $tmp[1] : FileUtils::mb_pathinfo($filePath, PATHINFO_BASENAME));
        }

        require_once $filePath;

        return true;
    }

    public static function loadClass($filePath, $className='')
    {
        $result = self::loadFile($filePath);
        if($result !== TRUE) {
            return $result;
        }
        try{
            if($className=='') {
                $className = ucwords(pathinfo($filePath, PATHINFO_FILENAME));
            }
            $instance = new $className();
            return $instance;
        }
        catch (Exception $e) {
            return $e->getMessage();
        }
        catch (Throwable $t) {
            return $t->getMessage();
        }
    }

    public static function controller($path)
    {
        $r = Router::controller($path);
        if(empty($r)) {
            throw new Exception('Failed to routing for controller: '.$path);
        }
        $filePath = $r['filePath'];
        $className = $r['className'];

        $instance = self::loadClass($filePath, $className);
        if(!is_object($instance) || !($instance instanceof Controller)) {
            throw new Exception($instance);
        } else {
            return $instance;
        }
    }

    public static function model($path)
    {
        $r = Router::model($path);
        if(empty($r)) {
            throw new Exception('Failed to routing for model: '.$path);
        }
        $filePath = $r['filePath'];
        $className = $r['className'];

        $instance = self::loadClass($filePath, $className);
        if(!is_object($instance) || !($instance instanceof Model)) {
            throw new Exception($instance);
        } else {
            return $instance;
        }
    }

    public static function view($path)
    {
        $r = Router::view($path);
        if(empty($r)) {
            throw new Exception('Failed to routing for view: '.$path);
        }
        $filePath = $r['filePath'];
        $className = $r['className'];

        if(!file_exists($filePath)) {
            $tmp = explode('protected', $filePath);
            $message = 'File not exist: ' . (isset($tmp[1]) ? $tmp[1] : FileUtils::getBasename($filePath));
            throw new Exception($message);
        }

        $instance = new View($filePath);
        if(!is_object($instance) || !($instance instanceof View)) {
            throw new Exception("View exception: " . $instance);
        } else {
            return $instance;
        }
    }
}