<?php
/**
 * Middleware class
 * It should be changed according to the specific operation of the application.
 * Used: Evening::run() method.
 *
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class Middleware
{
    /**
     * Runs before any request from client.
     * A developer can customize the method to be suited an application.
     */
	public static function run()
    {
        @date_default_timezone_set(CONFIG['timezone']);
        Security::init();

        $result = Language::import(Security::getLanguage());

        // Only valid by setting traceable['active'] = true in config.json.
        Track::access();
    }

    /**
     * If occurs an error, please define in this method to process them.
     * Parameter must be type of Exception
     * Used in Evening::run()
     * @param $error Exception
     */
    public static function errors($error)
    {
        @date_default_timezone_set(CONFIG['timezone']);

        $msg = $error->getMessage();
        $file = $error->getFile();
        $line = $error->getLine();

        $track = $msg.PHP_EOL.$file." : ".$line;
        Track::errors($track);

        if(DEBUG) {
            $message = Filter::safeString($msg).gLineCharacter();
            $message .= str_replace(gURL('protected'), '', $file)." : ".$line;
            $page = new Errors('404');
            $page->message = $message;
            $page->show();
        }

        exit;
    }
}