<?php
/**
 * View base class
 * @package base
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2019, EVENING
 */
class View
{
	protected $_file;
	protected $_data = array();
	
	public function __construct($val)
	{
        $this->_file = $val;

        if(!file_exists($this->_file)) {
            throw new Exception("View " . $this->_file . " doesn't exist.");
        }
	}
    
	public function set($key, $value)
	{
		$this->_data[$key] = $value;
		return $this;
	}
	
	public function get($key)
	{
   		return $this->_data[$key];
  	}
	
	public function output()
    {
        extract($this->_data);
        // The following logic that is usable instead of extract() is faster.
        /*foreach ($this->_data as $key => $value) {
                $$key = $value;
        }*/
        ob_start();
        include($this->_file);
        $output = ob_get_contents();
        @ob_end_clean();
        echo $output;
	}

	public function cacheOutput($clientid=NULL)
    {
        $buffer = new Cache($this->_file, $clientid);
        if($buffer->check()) {
            $contents = $buffer->get();
            echo $contents;
        } else {
            extract($this->_data);
            ob_start();
            include($this->_file);
            $output = ob_get_contents();
            @ob_end_clean();
            $buffer->write($output);
            echo $output;
        }
    }

    public function partial()
    {
        extract($this->_data);
        ob_start();
        include($this->_file);
        $output = ob_get_contents();
        @ob_end_clean();
        return $output;
    }

    public function cachePartial()
    {
        $buffer = new Cache($this->_file);
        if($buffer->check()) {
            $contents = $buffer->get();
            return $contents;
        } else {
            extract($this->_data);
            ob_start();
            include($this->_file);
            $output = ob_get_contents();
            @ob_end_clean();
            $buffer->write($output);
            return $output;
        }
    }

    public function setHttpStatusHeader($code=200, $text='')
    {
        if (empty($code) OR ! is_numeric($code))
        {
            die('Status codes must be numeric: '.$code);
        }

        if (empty($text))
        {
            is_int($code) OR $code = (int) $code;
            $stati = array(
                100	=> 'Continue',
                101	=> 'Switching Protocols',

                200	=> 'OK',
                201	=> 'Created',
                202	=> 'Accepted',
                203	=> 'Non-Authoritative Information',
                204	=> 'No Content',
                205	=> 'Reset Content',
                206	=> 'Partial Content',

                300	=> 'Multiple Choices',
                301	=> 'Moved Permanently',
                302	=> 'Found',
                303	=> 'See Other',
                304	=> 'Not Modified',
                305	=> 'Use Proxy',
                307	=> 'Temporary Redirect',

                400	=> 'Bad Request',
                401	=> 'Unauthorized',
                402	=> 'Payment Required',
                403	=> 'Forbidden',
                404	=> 'Not Found',
                405	=> 'Method Not Allowed',
                406	=> 'Not Acceptable',
                407	=> 'Proxy Authentication Required',
                408	=> 'Request Timeout',
                409	=> 'Conflict',
                410	=> 'Gone',
                411	=> 'Length Required',
                412	=> 'Precondition Failed',
                413	=> 'Request Entity Too Large',
                414	=> 'Request-URI Too Long',
                415	=> 'Unsupported Media Type',
                416	=> 'Requested Range Not Satisfiable',
                417	=> 'Expectation Failed',
                422	=> 'Unprocessable Entity',
                426	=> 'Upgrade Required',
                428	=> 'Precondition Required',
                429	=> 'Too Many Requests',
                431	=> 'Request Header Fields Too Large',

                500	=> 'Internal Server Error',
                501	=> 'Not Implemented',
                502	=> 'Bad Gateway',
                503	=> 'Service Unavailable',
                504	=> 'Gateway Timeout',
                505	=> 'HTTP Version Not Supported',
                511	=> 'Network Authentication Required',
            );

            if (isset($stati[$code]))
            {
                $text = $stati[$code];
            }
            else
            {
                die('No status text available. Please check your status code number or supply your own message text.');
            }
        }

        $status = array(
            'code'=>$code,
            'status'=>$text
        );
        gIsCLI() OR @header('Status: '.$code.' '.$text, TRUE, $code); // Modified by jjb 2020.04.24. Added '@' for cli version
        return $status;
    }
}