<?php
/**
 * Super global define code.
 * In this code defined variable, method is global.
 * So u take care to define the method or variable to avoid define as duplicate name in other code.
 * Global methods naming must use prefix - 'g' as first character.
 * The defined methods can be accessed directly calling them.
 */
/**
 * Define is usable mod_rewrite module in Apache
 * Please find <LoadModule rewrite_module modules/mod_rewrite.so> at httpd.conf
 * If enabled MOD_RERITE = true or false
 */
define('MOD_REWRITE', gModRewrite());

define('BASE_URL', gGetBaseURL());

/**
 * Root url of http request.
 * If framework source placed on DocumentRoot then value = '', otherwise set specify a start path.
 */
function gGetBaseURL()
{
    $base = ''; // Default

    if(gIsCLI()) return $base;

    $app_root = str_replace(array('\\', '/'), array(DS, DS), DOC_ROOT);
    $env_root = str_replace(array('\\', '/'), array(DS, DS), $_SERVER['DOCUMENT_ROOT']);
    $arr = explode($env_root, $app_root);

    if(is_array($arr) && count($arr)==2) {
        $base = $arr[1];
    }
    $base = str_replace(DS, '/', $base);
    if(!empty($base)) {
        if(strpos($base, '/')!==0) {
            $base = '/'.$base;
        }
    }

    return $base;
}

function gModRewrite()
{
    if(gIsCLI() && !function_exists('apache_get_modules')) {
        return true;
    }
    return in_array('mod_rewrite', apache_get_modules());
}

function gIsCLI()
{
    return (PHP_SAPI === 'cli' OR defined('STDIN'));
}

/**
 * In other code, can be used like gURL('http_root')
 * About http_root: if root folder located at documentRoot of httpd.conf, the value is '/'
 */
function gURL($index)
{
    $g_config_url = array(
        //'http_root'=>   MOD_REWRITE? BASE_URL.'/' : BASE_URL.'/?evening=',
        'http_root'=>   MOD_REWRITE? BASE_URL : BASE_URL.'/index.php',
        'http_assets'=> BASE_URL.'/assets',

        // for file system
        'doc_root'=>    DOC_ROOT,
        'protected'=>   DOC_ROOT.DS."protected",
        'app'=>         DOC_ROOT.DS."protected".DS."app",
        'base'=>        DOC_ROOT.DS."protected".DS."base",
        'controllers'=> DOC_ROOT.DS."protected".DS."controllers",
        'models'=>      DOC_ROOT.DS."protected".DS."models",
        'views'=>       DOC_ROOT.DS."protected".DS."views",
        'utils'=>       DOC_ROOT.DS."protected".DS."utils",
        'includes'=>    DOC_ROOT.DS."protected".DS."includes",
        'config'=>      DOC_ROOT.DS."protected".DS."config",
        'resource'=>    DOC_ROOT.DS."protected".DS."resource",
        'vendors'=>     DOC_ROOT.DS."protected".DS."vendors",
        'cache'=>       DOC_ROOT.DS."protected".DS."cache",
        'language'=>    DOC_ROOT.DS."protected".DS."language",
        'assets'=>      DOC_ROOT.DS."assets",

        // Add more custom url
        'upload'=>      DOC_ROOT.DS."protected".DS."resource".DS."uploads",
    );

    return isset($g_config_url[$index])? $g_config_url[$index] : '';
}

function gURLE($index) {
    echo gURL($index);
}

/**
 * Dedicate directories for search the class files
 * Evening::autoload() is to be refer this.
 * Each item find from gURL($index)
 */
function gClassMap()
{
   return array(
       'base',
       'controllers',
       'models',
       'app',
       'utils',
   );
}