<?php
/**
 * Super global define code.
 * In this code defined variable, method is global.
 * So u take care to define the method or variable to avoid define as duplicate name in other code.
 * Global methods naming must use prefix - 'g' as first character.
 * The defined methods can be accessed directly calling them.
 */

//define('LANG', isset($_SESSION['lang'])? $_SESSION['lang'] : 'ko');

//gImportLanguage();

function gImportLanguage($lang='en')
{
    $user_lang = trim($lang, " \t\n\r\0\x0B\x8\x1A/\\");
    $url = gURL('language').DS.$user_lang.'.php';
    if(file_exists($url)) {
        require_once $url;
    } else {
        die('Cannot find a language file: '.$url);
    }
}

// return text
function gText($index, $data=null)
{
    $lang = $GLOBALS['gLang'];
    if(!isset($lang[$index])) {
        return '';
    }
    else {
        $text = $lang[$index];
        if(empty($data)) {
            return $text;
        }
        else {
            return gTextR($text, $data);
        }
    }
}

// echo text
function gTextE($index, $data=null)
{
    echo gText($index, $data);
}

/**
 * Replace text with param
 * @param $text
 * @param $data array e.g. ['search'=>'replace'] '##search##' in $text replace to 'replace'
 * @return mixed
 */
function gTextR($text, $data)
{
    foreach ($data as $key=>$val) {
        $text = str_replace('##'.$key.'##', $val, $text);
    }
    return $text;
}