<?php
/**
 * Define full path of file for namespace.
 * EVENING prefer placed all namespace under /protected/vendors/
 * Example see /utils/Mailer.php using /vendors/PHPMailer
 * PHPMailer use namespace like:
 * use PHPMailer\PHPMailer\PHPMailer = \PHPMailer\PHPMailer\PHPMailer;
 * The namespace are divided path and class file
 * At Evening.php defines namespace is PHPMailer\PHPMailer and file name is PHPMailer.php
 * Actually PHPMailer.php file is located at 'vendors'.DS.'PHPMailer'.DS.'src'
 * So you need to config the actual file path for including.
 * If not found defined namespace from this array, then automatically will find from /protected/ folder + namespace path
 * For example, new /controllers/admin/TestNamespaceController() means to include /protected/controllers/admin/TestNamespaceController.php
 * Please refer test code from /controllers/HomeController.php and testNamespace() method.
 */
return array(
    'PHPMailer\PHPMailer' => gURL('namespace').DS.'PHPMailer'.DS.'src',
    'Gumlet' => gURL('namespace').DS.'ImageMaster3'.DS.'lib',
);