<?php
return array(
    'default'=> array(
        'controller'=>"home",
        'action'=>"index",
        'argument'=>NULL
    ),

    /**
     * Customize routing.
     *
     * Each item's type must be following:
     * 'URL Key'=> array('{Controller Name}' [, '{Action Name}' [, {Controller File Path}]])
     * e.g. 'admin/login'=>array('account', 'login', '/admin')
     * First index: Controller name, requires
     * Second index: Action name, optional
     * Third index: Controller path, optional
     *
     * 'path' is value of where is located controller file.
     * If path is undefined, default is empty string as ''.
     *
     * The controller is controller name, router will find at 'controllers/[path]/[controller]Controller.php'
     *
     * If action is undefined, default action is action value of 'default' index.
     *
     * The type of each key in array is formatted like 'controller/action' or 'controller'.
     *
     * Forward item has priority over backward item.
     *
     * !Important
     * This ignore modules rule.
     */
    'routes'=> array(
        '/blog/client'=> array('BlogClient'),
        '/callback/test'=> function($param1=null, $param2=null) {
            // Test URL: http://localhost/callback/test/123/456
            // Print: "You accessed callback with argument: 123 456"
            echo "You accessed callback with argument: ".$param1." ".$param2;
            // TODO: Any more logic
        },

        /**
         * HTTP요청타입을 구분할 필요가 있겠는지???
         * 필요하다면 Router::inRoutes() 부분의 코드를 약간 수정해야 한다.
         */
        /*
        'GET' => array(
            '/blog/client'=> array('BlogClient'),
        ),

        'POST' => array(
            '/blog/client'=> array('BlogClient'),
        ),

        'PUT' => array(

        ),

        'DELETE' => array(

        ),
        */
    ),

    /**
     * Define sub-application.
     * For example, if you want that backend application placed in 'controllers/admin' folder, then you can define sub-app here.
     * With url 'http://localhost/admin/account/login', default will be find controllers/AdminController and action account($param='login').
     * but defined 'admin' in modules, will be find controllers/admin/AccountController and action login()
     */
    'modules'=>array(
        '/admin', // Equal admin, admin/, /admin, /admin/
    )
);