<?php


class AccountController extends Controller
{
    protected function _beforeAction()
    {
        $m = $this->_setModel('Account');
        $result = $m->createTable();
        if(empty($result)) {
            die("Cannot create users table in SQL: ".$m->_dumpQuery());
        }
    }

    public function index()
    {
        $v = $this->_setView('account/index');
        $v->set('title', gText('menu_create'));
        $v->output();
    }

    public function register()
    {
        $v = $this->_setView('account/register');
        $v->set('title', gText('menu_create'));
        $v->output();
    }

    public function add()
    {
        $user_name = isset($_POST['user_name'])? $_POST['user_name'] : null;
        $user_email = isset($_POST['user_email'])? $_POST['user_email'] : null;
        $user_passwd = isset($_POST['user_passwd'])? $_POST['user_passwd'] : null;
        $user_repasswd = isset($_POST['user_repasswd'])? $_POST['user_repasswd'] : null;

        if(empty($user_name) || empty($user_passwd) || empty($user_email) || empty($user_repasswd)) {
            die("Invalid request data");
        }

        if(!Validator::isEmail($user_email)) {
            die("Invalid email type");
        }

        if($user_passwd !== $user_repasswd) {
            die("Not matched password and re-password");
        }

        $m = $this->_setModel('Account');
        $m->setName($user_name);
        $m->setEmail($user_email);
        $m->setPassword($user_passwd);
        $result = $m->add();

        if(empty($result)) {
            die("\nDuplicated user");
        }

        echo 1;
    }

    public function all()
    {
        $m = $this->_setModel('Account');
        $result = $m->getUserAll();

        echo json_encode($result);
    }

    public function delete()
    {
        $id = isset($_POST['id'])? $_POST['id'] : NULL;

        if(empty($id)) die("Invalid id");

        $m = $this->_setModel('Account');
        $m->setId($id);
        $result = $m->delete();

        if(empty($result)) die("\nFailed to delete: ".Filter::safeString($id));

        echo 1;
    }

    public function edit()
    {
        $id = isset($_GET['id'])? $_GET['id'] : NULL;

        if(empty($id)) die("Invalid id");

        $m = $this->_setModel('Account');
        $m->setId($id);
        $result = $m->getUserById();

        if(empty($result)) die("No data: ".Filter::safeString($id));

        $v = $this->_setView('account/edit');
        $v->set('data', $result);
        $v->output();
    }

    public function save()
    {
        $user_id = isset($_POST['id'])? $_POST['id'] : null;
        $user_name = isset($_POST['user_name'])? $_POST['user_name'] : null;
        $user_email = isset($_POST['user_email'])? $_POST['user_email'] : null;
        $user_passwd = isset($_POST['user_passwd'])? $_POST['user_passwd'] : null;
        $user_repasswd = isset($_POST['user_repasswd'])? $_POST['user_repasswd'] : null;

        if(empty($user_id) || empty($user_name) || empty($user_passwd) || empty($user_email) || empty($user_repasswd)) {
            die("Invalid request data");
        }

        if(!Validator::isEmail($user_email)) {
            die("Invalid email type");
        }

        if($user_passwd !== $user_repasswd) {
            die("Not matched password and re-password");
        }

        $m = $this->_setModel('Account');
        $m->setId($user_id);
        $m->setName($user_name);
        $m->setEmail($user_email);
        $m->setPassword($user_passwd);
        $result = $m->update();

        if(empty($result)) {
            die($m->_dumpQuery());
        }

        echo 1;
    }
}