<?php


class BlogClientController extends Controller
{
    protected function _beforeAction()
    {
        $m = $this->_setModel('Blog');
        $m->createTable();
    }

    public function index()
    {
        $v = $this->_setView('blog/client/index');
        $v->set('title', gText('menu_blog'));
        $v->output();
    }

    public function all()
    {
        $m = $this->_setModel('Blog');
        $result = $m->getAll();
        if(empty($result)) $result = [];
        $data = array();
        foreach ($result as $item) {
            unset($item['contents']);
            $data[] = $item;
        }

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
    }

    public function view($id=NULL)
    {
        if(empty($id)) die("Invalid id");

        $m = $this->_setModel('Blog');
        $m->setId($id);
        $blog = $m->get();

        $v = $this->_setView('blog/client/view');
        $v->set('title', $blog['title']);
        $v->set('blog', $blog);
        return $v->output();
    }
}