<?php


class BlogController extends Controller
{
    protected function _beforeAction()
    {
        $m = $this->_setModel('Blog');
        $m->createTable();
    }

    public function index()
    {
        $v = $this->_setView('blog/index');
        $v->set('title', gText('menu_blog'));
        $v->output();
    }

    public function view($id=NULL)
    {
        if(empty($id)) die("Invalid id");

        $m = $this->_setModel('Blog');
        $m->setId($id);
        $blog = $m->get();
        if(empty($blog)) die('No data');
        $v = $this->_setView('blog/view');
        $v->set('title', $blog['title']);
        $v->set('blog', $blog);
        return $v->output();
    }

    public function all()
    {
        $m = $this->_setModel('Blog');
        $result = $m->getAll();
        if(empty($result)) $result = [];
        $data = array();
        foreach ($result as $item) {
            unset($item['contents']);
            $data[] = $item;
        }

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
    }

    public function post()
    {
        $v = $this->_setView('blog/post');
        $v->set('title', gText('menu_blog'));
        $v->output();
    }

    public function create()
    {
        $contents = isset($_POST['contents'])? $_POST['contents'] : null;
        $title = isset($_POST['title'])? $_POST['title'] : null;
        $state = isset($_POST['state'])? $_POST['state'] : 0;

        if(empty($contents) || empty($title)) {
            echo 'error1';
            exit;
        }

        $m = $this->_setModel('Blog');
        $m->setTitle($title);
        $m->setContents($contents);
        $m->setState($state);
        $result = $m->create();
        echo empty($result)? 'error2' : 'success';
    }

    public function edit()
    {
        $id = isset($_GET['id'])? $_GET['id'] : null;
        if(empty($id)) {
            die("Invalid id");
        }

        $m = $this->_setModel('Blog');
        $m->setId($id);
        $blog = $m->get();
        if(empty($blog)) die('No data');

        $v = $this->_setView('blog/edit');
        $v->set('title', $blog['title']);
        $v->set('blog', $blog);
        return $v->output();
    }

    public function delete($id=NULL)
    {
        if(empty($id)) die("Invalid id");

        $m = $this->_setModel('Blog');
        $m->setId($id);
        $result = $m->delete();
        echo $result? 'success' : 'fail';
    }

    public function save()
    {
        $blogid = isset($_POST['blogid'])? Filter::toInt($_POST['blogid']) : null;
        $contents = isset($_POST['contents'])? $_POST['contents'] : null;
        $title = isset($_POST['title'])? $_POST['title'] : null;
        $state = isset($_POST['state'])? $_POST['state'] : -1;

        if(empty($blogid) || empty($contents) || empty($title)) {
            echo 'error1';
            exit;
        }

        $m = $this->_setModel('Blog');
        $m->setId($blogid);
        $m->setTitle($title);
        $m->setContents($contents);
        $m->setState($state);
        $result = $m->save();
        echo empty($result)? 'error2' : 'success';
    }
}