<?php


class FilesController extends Controller
{
    public function index()
    {
        $v = $this->_setView('files/index');
        $v->set('title', gText('menu_files'));
        $v->set('contents', gText('files_contents'));
        $v->set('files', $this->_fileList());
        $v->output();
    }

    public function upload()
    {
        $file = isset($_FILES['userfile']) && $_FILES['userfile']['size']>0? $_FILES['userfile'] : null;

        if(empty($file)) die("No files.");

        $path = gURL('upload').DS.FileUtils::mb_pathinfo(trim($file['name']), PATHINFO_BASENAME);

        if (@move_uploaded_file($file['tmp_name'], $path)) {
            echo 1;
        } else {
            echo 0;
        }
    }

    private function _fileList()
    {
        $root = gURL('upload');
        $tmp = FileUtils::findAllFiles($root);
        $files = array();
        foreach ($tmp as $item) {
            $files[] = FileUtils::mb_pathinfo($item, PATHINFO_BASENAME);
        }

        return $files;
    }

    public function download()
    {
        $filename = isset($_GET['filename'])? trim($_GET['filename']) : NULL;
        if(empty($filename)) die("No filename");

        $path = gURL('upload').DS.FileUtils::mb_pathinfo($filename, PATHINFO_BASENAME);

        $d = new FileDownloader();
        $d->download($path);
    }

    public function all()
    {
        $files = $this->_fileList();
        echo json_encode($files, JSON_UNESCAPED_UNICODE);
    }

    public function delete()
    {
        $filename = isset($_POST['filename'])? trim($_POST['filename']) : NULL;
        if(empty($filename)) die("No filename");

        $path = gURL('upload').DS.FileUtils::mb_pathinfo($filename, PATHINFO_BASENAME);
        if(!file_exists($path)) {
            die("No exist file: ".Filter::safeString($path));
        }
        @unlink($path);
        echo 1;
    }
}