<?php
class AccountModel extends Model
{
    private $_id = NULL;
    private $_name = NULL;
    private $_email = NULL;
    private $_password = NULL;

    public function setId($val)
    {
        $this->_id = Filter::toInt($val);
    }
    public function setName($val)
    {
        $this->_name = Filter::safeString($val);
    }
    public function setEmail($val)
    {
        $this->_email = Filter::safeString($val);
    }
    public function setPassword($val)
    {
        $this->_password = Filter::hashPassword($val);
    }

    public function getUserAll()
    {
        $sql = "SELECT * FROM users ORDER BY id DESC";
        $result = $this->_set($sql)->_getAll();
        if(empty($result)) return [];
        return $result;
    }

    public function getUserById()
    {
        $sql = "SELECT * FROM users WHERE id=?";
        $data = array($this->_id);
        $target = $this->_set($sql, $data);
        $result = $target->_getRow();
        if(empty($result)) return NULL;
        return $result;
    }

    public function getUserByNameOREmail()
    {
        $sql = "SELECT * FROM users WHERE name=:name OR email=:email";
        $data = array(':name'=>$this->_name, ':email'=>$this->_email);
        $result = $this->_set($sql, $data)->_getRow();
        if(empty($result)) return NULL;
        return $result;
    }

    public function update()
    {
        $this->_transBegin();
        $sql = "UPDATE users SET name=:name, email=:email, password=:password WHERE id=:id";
        $data = array(':name'=>$this->_name, ':email'=>$this->_email, ':password'=>$this->_password, ':id'=>$this->_id);
        $result = $this->_set($sql, $data)->_update();
        if(empty($result)) {
            $this->_transBack();
            return false;
        }
        $this->_transCommit();
        return $result;
    }

    public function add()
    {
        $this->_transBegin();
        $sql = "INSERT INTO users (name, email, password) VALUES (?,?,?)";
        $data = array($this->_name, $this->_email, $this->_password);
        $result = $this->_set($sql, $data)->_insert();
        if(empty($result)) {
            $this->_transBack();
            return false;
        }
        $id = $this->_lastInserted();
        $this->_transCommit();
        return $id;
    }

    public function delete()
    {
        $sql = "DELETE FROM users WHERE id=?";
        $data = array($this->_id);
        $result = $this->_set($sql, $data)->_remove();
        return $result;
    }

    public function createTable()
    {
        //$this->_transSwitch(true);

        $sql = "CREATE TABLE IF NOT EXISTS `users` (
          `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
          `email` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
          `password` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
          `reg_date` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
          PRIMARY KEY (`id`) USING BTREE,
          UNIQUE INDEX `name`(`name`) USING BTREE,
          UNIQUE INDEX `email`(`email`) USING BTREE
        ) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact";

        $result = $this->_set($sql)->_run();

        //$this->_transSwitch(false);

        return $result;
    }
}