<?php


class BlogModel extends Model
{
    private $_id = NULL;
    private $_title = NULL;
    private $_contents = NULL;
    private $_categoryid = NULL;
    private $_reg_date = NULL;
    private $_state = NULL;

    public function setId($val)
    {
        $this->_id = Filter::toInt($val);
    }
    public function setTitle($val)
    {
        $this->_title = Filter::safeString($val);
    }
    public function setContents($val)
    {
        $this->_contents = Filter::safeString($val);
    }
    public function setState($val)
    {
        $this->_state = Filter::toInt($val);
    }

    public function createTable()
    {
        //$this->_transSwitch(true);

        $sql = "CREATE TABLE IF NOT EXISTS `blog`  (
                  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                  `title` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
                  `contents` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
                  `categoryid` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
                  `reg_date` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
                  `reg_user` int(10) UNSIGNED NULL DEFAULT NULL,
                  `state` tinyint(3) NOT NULL DEFAULT 1,
                  PRIMARY KEY (`id`) USING BTREE
                ) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;";

        $result = $this->_set($sql)->_run();

        //$this->_transSwitch(false);
        return $result;
    }

    public function getAll()
    {
        $sql = "SELECT * FROM blog ORDER BY id DESC";
        $result = $this->_set($sql)->_getAll();
        return $result;
    }

    public function get()
    {
        $sql = "SELECT * FROM blog WHERE id=:id";
        $data = array(':id'=>$this->_id);
        $result = $this->_set($sql, $data)->_getRow();
        return $result;
    }

    public function create()
    {
        $sql = "INSERT INTO blog (title, contents, state) VALUES (?, ?, ?)";
        $data = array(
            $this->_title,
            $this->_contents,
            $this->_state,
        );
        $result = $this->_set($sql, $data)->_insert();
        return $result;
    }

    public function delete()
    {
        $sql = "DELETE FROM blog WHERE id=?";
        $result = $this->_set($sql, array($this->_id))->_remove();
        return $result;
    }

    public function save()
    {
        $sql = "UPDATE blog SET title=?, contents=?, state=? WHERE id=?";
        $data = array(
            $this->_title,
            $this->_contents,
            $this->_state,
            $this->_id
        );
        $result = $this->_set($sql, $data)->_update();
        return $result;
    }
}