<?php
/**
 * FileDownloader is a helper class serving some functionalities for downloading any file.
 * Tested on RedStar, Linux (Apache) and Windows (IIS5/6) under PHP4.3.x
 * IE 6.0+, FF, Chrome, Safari, Opera
 * By writing your own FileDownloader class, you can customize some functionalities
 *
 * @package utils
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2017, EVENING
 */
class FileDownloader
{
    private $_isUseSession = false;
    private $_downName = '';
        
    /**
    * Setter value for checking use sesion.
    * @param boolean
    */
    public function setUseSession($val)
    {
        $this->_isUseSession = (bool)$val;
    }

    public function setDownName($val)
    {
        $this->_downName = $val;
    }
    
    /**
    * Getter value for checking use sesion.
    * @return boolean Default is false.
    */
    public function getUseSession()
    {
        return $this->_isUseSession;
    }
    
    /**
    * Executes a downloading.
    * Works with large files, and uses an 64KB buffer per transfer in default.
    * Sends a number of headers, including ones that ensure it's cached for a maximum of 2 hours on any browser/proxy.
    * 
    * @return boolean Returns TRUE if transfer was completed, 
    * or FALSE if the client was disconnected before completing the download.
    */
    public function download($path, $buf=64)
    {
        $fullpath = $path;
        $name = (empty($this->_downName))? pathinfo($fullpath)['basename'] : $this->_downName;

        if(strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) // Browser is Internet Explorer
        {
            $filename = urlencode($name);
            $filename = preg_replace('/\./', '%2e', $filename, substr_count($filename, '.') - 1);
            $filename = basename(str_replace("+", "%20", $filename));
        }
        else $filename = $name;


        if (!is_file($fullpath) or connection_status()!=0) return(false);

        while(ob_get_level()) @ob_end_clean();

        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Pragma: public");
        header("Expires: ".gmdate("D, d M Y H:i:s", mktime(date("H")+2, date("i"), date("s"), date("m"), date("d"), date("Y")))." GMT");
        header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
        header("Content-Type: application/octet-stream");
        header("Content-Length: ".(string)(filesize($fullpath)));
        header("Content-Disposition: inline; filename=\"$filename\""); // Important the quotes \"\" for Firefox
        header("Content-Transfer-Encoding: binary\n");

        if($this->getUseSession() === true) session_write_close();

        if ($file = fopen($fullpath, 'rb'))
        {
            while(!feof($file) and (connection_status()==0))
            {
                set_time_limit(0); // Need if use max_execution_time set with php.ini.
                print(fread($file, 1024*intval($buf)));
                @ob_flush();
                @flush();
            }
            fclose($file);
        }
        return((connection_status()==0) and !connection_aborted());
    }
}