<?php
/**
 * File utility class
 * @package utils
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2017, EVENING
 */
class FileUtils
{
    function streamOut($path, $outname=null, $buf=64)
    {
        $name = $outname? $outname : pathinfo($path)['basename'];

        if(strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) // Browser is Internet Explorer
        {
            $filename = urlencode($name);
            $filename = preg_replace('/\./', '%2e', $filename, substr_count($filename, '.') - 1);
            $filename = basename(str_replace("+", "%20", $filename));
        }
        else $filename = $name;

        $mime = Mime::mimeByFilename($path);
        while(ob_get_level()) @ob_end_clean();
        //flush(); // Added by JJB 2017.02.19, This doesn't really matter.
        header(sprintf('Content-type: %s;', $mime));
        header('Content-Length: ' . filesize($path));
        header("Content-Disposition: inline; filename=\"$filename\""); // Important the quotes \"\" for Firefox

        //@ob_end_clean(); // Commented by JJB 2017.02.19
        if ($file = fopen($path, 'rb'))
        {
            while(!feof($file) and (connection_status()==0))
            {
                set_time_limit(0); // Need if use max_execution_time set with php.ini.
                print(fread($file, 1024*intval($buf)));
                ob_flush();
                flush();
            }
            fclose($file);
        }
        return((connection_status()==0) and !connection_aborted());
    }
    /**
     * @param $path Full path like 'D:/a/b/c.png'
     */
    public function output($path, $outname=null)
    {
        $name = $outname? $outname : pathinfo($path)['basename'];

        if(strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) // Browser is Internet Explorer
        {
            $filename = urlencode($name);
            $filename = preg_replace('/\./', '%2e', $filename, substr_count($filename, '.') - 1);
            $filename = basename(str_replace("+", "%20", $filename));
        }
        else $filename = $name;

        $mime = Mime::mimeByFilename($path);

        /*$this->streamOut($path, $filename);
        return;*/

        while(ob_get_level()) @ob_end_clean();

        header(sprintf('Content-type: %s', $mime));
        header('Content-Length: ' . filesize($path));
        header("Content-Disposition: inline; filename=\"$filename\""); // Important the quotes \"\" for Firefox
        set_time_limit(0);
        readfile($path);
        exit;
    }

    function smartRead($location, $filename, $mimeType='application/octet-stream')
    {
        if(!file_exists($location))
        {
            header ("HTTP/1.0 404 Not Found");
            return;
        }

        @ob_end_clean();

        $size=filesize($location);
        $time=date('r',filemtime($location));

        $fm=@fopen($location,'rb');
        if(!$fm)
        {
            header ("HTTP/1.0 505 Internal server error");
            return;
        }

        $begin=0;
        $end=$size;

        if(isset($_SERVER['HTTP_RANGE']))
        {
            if(preg_match('/bytes=\h*(\d+)-(\d*)[\D.*]?/i', $_SERVER['HTTP_RANGE'], $matches))
            {
                $begin=intval($matches[0]);
                if(!empty($matches[1]))
                    $end=intval($matches[1]);
            }
        }

        if($begin>0||$end<$size)
            header('HTTP/1.0 206 Partial Content');
        else
            header('HTTP/1.0 200 OK');

        header("Content-Type: $mimeType");
        header('Cache-Control: public, must-revalidate, max-age=0');
        header('Pragma: no-cache');
        header('Accept-Ranges: bytes');
        header('Content-Length:'.($end-$begin));
        header("Content-Range: bytes $begin-$end/$size");
        header("Content-Disposition: inline; filename=\"$filename\"");
        header("Content-Transfer-Encoding: binary\n");
        header("Last-Modified: $time");
        header('Connection: close');

        $cur=$begin;
        fseek($fm,$begin,0);

        while(!feof($fm)&&$cur<$end&&(connection_status()==0))
        {
            print fread($fm,min(1024*16,$end-$cur));
            $cur+=1024*16;
        }
    }


    public static function makeDir($path)
    {
        if(file_exists($path) && is_dir($path)) {
            chmod($path,0777);
            return true;
        }
        if(!@mkdir($path, 0777, true)) {
            return false;
        } else {
            chmod($path,0777);
            return true;
        }
    }
    /**
     *
     * @param $filename
     *
     * @return string
     */
    public function getExtension($filename)
    {
        return strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    }

    public static function getExtension1($path)
    {
        $c = preg_match('#[^\/]+\.([^\.]*)$#uis', $path, $tmp);
        return $c ? strtolower($tmp[1]) : null;
    }

    public static function getFileName($filename)
    {
        return pathinfo($filename, PATHINFO_FILENAME);
    }

    /**
     * Best function!!!
     * Multi-byte-safe pathinfo replacement.
     * Drop-in replacement for pathinfo(), but multibyte- and cross-platform-safe.
     *
     * @see    http://www.php.net/manual/en/function.pathinfo.php#107461
     *
     * @param string     $path    A filename or path, does not need to exist as a file
     * @param int|string $options Either a PATHINFO_* constant,
     *                            or a string name to return only the specified piece
     *
     * @return string|array
     */
    public static function mb_pathinfo($path, $options = null)
    {
        $ret = array('dirname' => '', 'basename' => '', 'extension' => '', 'filename' => '');
        $pathinfo = array();
        if (preg_match('#^(.*?)[\\\\/]*(([^/\\\\]*?)(\.([^.\\\\/]+?)|))[\\\\/.]*$#m', $path, $pathinfo)) {
            if (array_key_exists(1, $pathinfo)) {
                $ret['dirname'] = $pathinfo[1];
            }
            if (array_key_exists(2, $pathinfo)) {
                $ret['basename'] = $pathinfo[2];
            }
            if (array_key_exists(5, $pathinfo)) {
                $ret['extension'] = $pathinfo[5];
            }
            if (array_key_exists(3, $pathinfo)) {
                $ret['filename'] = $pathinfo[3];
            }
        }
        switch ($options) {
            case PATHINFO_DIRNAME:
            case 'dirname':
                return $ret['dirname'];
            case PATHINFO_BASENAME:
            case 'basename':
                return $ret['basename'];
            case PATHINFO_EXTENSION:
            case 'extension':
                return $ret['extension'];
            case PATHINFO_FILENAME:
            case 'filename':
                return $ret['filename'];
            default:
                return $ret;
        }
    }

    /**
     * Binary-safe with multi-byte characters.
     * @param $file string
     * @return mixed
     */
    public static function getBasename($file)
    {
        $file = str_replace('\\', '/', $file);
        $arr = explode('/', $file);
        return end($arr);
    }

    public static function save($path, $data) {
        $fp = @fopen($path, 'w');
        if($fp) {
            @fwrite($fp, $data);
        }
        @fclose($fp);
        return true;
    }

    /**
     * @param $file string File path
     * @param $search string|array New contents
     * @param $replace string|array Original contents
     * @param $to null|string Save path
     * @return bool
     */
    public static function replaceContents($file, $search, $replace, $to=null)
    {
        $contents = @file_get_contents($file);
        if($contents === false) return false;
        $contents = str_replace($search, $replace, $contents);
        $target = $to? $to : $file;
        $result = @file_put_contents($target, $contents, LOCK_EX);
        if($result === false) return false;
        return true;
    }

    public static function move($old, $new)
    {
        $result = @copy($old, $new);
        if(!empty($result)) {
            @unlink($old);
        }
    }

    /**
     * Because PHP's integer type is signed and many platforms use 32bit integers,
     * some filesystem functions may return unexpected results for files whichare larger than 2GB.
     *
     * This one really better and faster.
     *
     * @param $file
     * @return false|int|string Return file size (even for file > 2 Gb)
     */
    public static function getFileSize($file) {
        if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
            $size = trim(exec("for %F in (\"" . $file . "\") do @echo %~zF"));
        }
        elseif ((PHP_OS == 'Linux') || (PHP_OS == 'FreeBSD') || (PHP_OS == 'Unix') || (PHP_OS == 'SunOS')) {
            $size = trim(shell_exec("stat -c%s " . escapeshellarg($file)));
        } else {
            $size = @filesize($file);
        }
        return $size;
    }

    public static function findAllFiles($dir)
    {
        $result = array();
        $root = scandir($dir);
        foreach($root as $value)
        {
            if($value === '.' || $value === '..') {continue;}
            if(is_file("$dir".DIRECTORY_SEPARATOR."$value")) {$result[]="$dir".DIRECTORY_SEPARATOR."$value";continue;}
            foreach(self::findAllFiles("$dir".DIRECTORY_SEPARATOR."$value") as $value)
            {
                $result[]=$value;
            }
        }
        return $result;
    }

    public static function deleteAll($src)
    {
        if (file_exists($src)) {
            $dir = opendir($src);
            while (false !== ($file = readdir($dir))) {
                if (($file != '.') && ($file != '..')) {
                    $full = $src . '/' . $file;
                    if (is_dir($full)) {
                       self::deleteAll($full);
                    } else {
                        @unlink($full);
                    }
                }
            }
            closedir($dir);
            rmdir($src);
        }
    }
}