<?php
/**
 * Filters class
 * @package utils
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com
 * @copyright Copyright (c) 2017, EVENING
 */
class Filter
{
    /**
     * For preventing SQL injection!!!!
     * PHP 5.4.0 The default value for the encoding parameter was changed to UTF-8.
     * If need to decode the filtered data, use htmlspecialchars_decode($input, ENT_QUTOES);.
     */
    public static function safeString($val)
    {
        $input = self::toStr($val);
		return self::escape(htmlspecialchars($input, ENT_QUOTES, 'UTF-8'));
    }
    public static function unsafeString($val)
    {
        $input = self::toStr($val);
        return htmlspecialchars_decode(self::unescape($input), ENT_QUOTES);
    }
    /**
     * Important not use mysql_real_escape_string() !!!!
     * You should use mysql_real_escape_string only before inserting the data into your table 
     * , otherwise you could just use this function :
     */
    public static function escape($val)
    {
        //$search = array("\\", "\0", "\n", "\r", "\x1a");
        //$replace= array("\\\\", "\\0", "\\n", "\\r", "\Z");
        $search = array("\\", "\0", "\x1a", "\x8");
        $replace= array("\\\\", "\\0", "\\Z", "\\b");
        return str_replace($search, $replace, $val); 
    }
    public static function unescape($val)
    {
        //$search= array("\\\\", "\\0", "\\n", "\\r", "\Z");
        //$replace = array("\\", "\0", "\n", "\r", "\x1a");
        $search= array("\\\\");
        $replace = array("\\");
        return str_replace($search, $replace, $val);
    }

    public static function nl2br2($val)
    {
        return str_replace(array("\r\n", "\r", "\n", "\\r\\n", "\\r", "\\n"), "<br>", $val);
    }
    public static function br2nl($val)
    {
        return str_replace(array("<br>", "</br>"), "\r\n", $val);
    }
    /**
     * Important the name. rename() defined already in PHP!!!
     */
    public static function rename2($val)
    {
    	return $val;
    }

    public static function jsAlert($val)
    {
        echo "<script>alert('".htmlspecialchars($val)."')</script>";
    }

    public static function stripHTML($val)
    {
        //$html_reg = '/<+\s*\/*\s*([A-Z][A-Z0-9]*)\b[^>]*\/*\s*>+/i';
        $html_reg = '/<[^>]+>/i';
        return htmlentities( preg_replace( $html_reg, '',  $val));
    }

    public static function decode_url($str)
    {
        if (stripos($str, '%') !== false)
        {
            do
            {
                $oldstr = $str;
                $str = rawurldecode($str);
                $str = preg_replace_callback('#%(?:\s*[0-9a-f]){2,}#i',
                    function($matches) {
                        $input    = $matches[0];
                        $nospaces = preg_replace('#\s+#', '', $input);
                        return ($nospaces === $input)
                            ? $input
                            : rawurldecode($nospaces);
                    }, $str);
            }
            while ($oldstr !== $str);
            unset($oldstr);
        }
        return $str;
    }

    public static function to_utf8( $string )
    {
        // From http://w3.org/International/questions/qa-forms-utf-8.html
        if ( preg_match('%^(?: 
               [\x09\x0A\x0D\x20-\x7E]            # ASCII 
             | [\xC2-\xDF][\x80-\xBF]             # non-overlong 2-byte 
             | \xE0[\xA0-\xBF][\x80-\xBF]         # excluding overlongs 
             | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte 
             | \xED[\x80-\x9F][\x80-\xBF]         # excluding surrogates 
             | \xF0[\x90-\xBF][\x80-\xBF]{2}      # planes 1-3 
             | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15 
             | \xF4[\x80-\x8F][\x80-\xBF]{2}      # plane 16 
         )*$%xs', $string) )
        {
            return $string;
        } else {
            $result = @iconv( 'CP1252', 'UTF-8', $string);
            if($result === false) return $string;
            return $result;
        }
    }

    /**
     * Returns the string value of a variable
     *
     * This differs from strval in that it invokes __toString if an object is given
     * and the object has that method
     */
    public static function toStr ($val)
    {
        $flag = Validator::isStringable($val);
        if($flag === false) return null;

        // We use get_class_methods instead of method_exists to ensure that __toString is a public method
        if (is_object($val) && in_array("__toString", get_class_methods($val)))
            return strval($val->__toString());
        else
            return strval($val);
    }

    public static function toInt($val)
    {
        $flag = Validator::isIntegerable($val);
        if($flag === false) return null;
        return intval($val);
    }

    /**
     * Manage password
     * @param $val
     * @return bool|string
     */
    public static function hashPassword($val)
    {
        if(!Validator::isStringable($val)) {
            return null;
        }
        $hash = password_hash($val, PASSWORD_DEFAULT);
        return $hash;
    }
    public static function checkPassword($val, $hash)
    {
        if(!Validator::isStringable($val)) {
            return null;
        }
        $result = password_verify($val, $hash);
        return $result;
    }
}