<?php
/**
 * Formatters class
 * @package utils
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2017, EVENING
 */

class Formatter
{
    /**
     * If the value is 12345678, then it is converted to 12 345 678
     */
    public static function formatNumber($val)
    {
        if(!empty($val)) return number_format($val, 0, '', ' ');
        return $val;
    }
    
    /**
     * 2017-08-09 09:05:01 to 2017.8.9
     */
    public static function formatDate($val)
    {
        if(!empty($val)) return date('Y.n.j', strtotime($val));
        return $val;
    }
    
    /**
     * 2017-08-09 09:05:01 to 2017.8.9 9:5:1
     */
    public static function formatDateTime($val)
    {
        if(!empty($val)) return date('Y.n.j G:i:s', strtotime($val));
        return $val;
    }
}