<?php
use \Gumlet\ImageResize;


class ImageMaster
{
    public $original;
    public $target;
    public $wizard;
    public $saveType;
    public $quality;

    public function __construct()
    {
        $this->saveType = null;
        $this->quality = null;
    }

    public function setSource($val)
    {
        $this->original = $val;
    }

    public function setTarget($val)
    {
        $this->target = $val;
    }

    public function setQuality($val)
    {
        $this->quality = $val;
    }

    public function setType($val)
    {
        switch ($val) {
            case 'png':
                $this->saveType = IMAGETYPE_PNG;
                break;
            case 'jpeg':
                $this->saveType = IMAGETYPE_JPEG;
                break;
            case 'gif':
                $this->saveType = IMAGETYPE_GIF;
                break;
        }
    }

    public function resize($w, $h)
    {
        $this->wizard = new ImageResize($this->original);
        $this->wizard->resizeToBestFit($w, $h)
            ->save($this->target, $this->saveType, $this->quality);
    }

    public function convert()
    {
        $this->wizard = new ImageResize($this->original);
        $this->wizard->save($this->target, $this->saveType, $this->quality);
    }

    public function rotate($angle, $bg=0)
    {
        $source = imagecreatefrompng($this->original);
        $sx = imagesx($source);
        $sy = imagesy($source);
        $temp_image = imagerotate($source, $angle, $bg);
        imagecopy($source, $temp_image, 0, 0, 0, 0, $sx, $sy);
        imagepng($source, 'rotate.png');
        imagedestroy($source);
    }
}