<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
/**
 * Mail class using PHPMailer, !Important, this is not static class
 * See: https://github.com/PHPMailer/PHPMailer
 *
 * hotmail: smtp.live.com, 587
 * gmail: smtp.gmail.com, 587
 *
 * @package utils
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2017, EVENING
 */
/*require gURL('vendors')."/PHPMailer/src/PHPMailer.php";
require gURL('vendors')."/PHPMailer/src/SMTP.php";
require gURL('vendors')."/PHPMailer/src/Exception.php";*/

class Mailer
{
    protected $to;
    protected $from;
    protected $sender;
    protected $readreceipt;
    protected $subject;
    protected $text;
    protected $html;
    protected $attachments = array();
    public $protocol = 'mail';
    public $hostname;
    public $username;
    public $password;
    public $port = 25;
    public $timeout = 5;
    public $newline = "\n";
    public $crlf = "\r\n";
    public $verp = false;
    public $parameter = '';
    public $isVerify = false;
    public $isDebug = false;

    /**
     * @param $to array|string of mail address
     */
    public function setTo($to) {
        $this->to[] = $to;
    }

    public function setFrom($from) {
        $this->from = $from;
    }

    public function setSender($sender) {
        $this->sender = $sender;
    }

    public function setReadReceipt($readreceipt) {
        $this->readreceipt = $readreceipt;
    }

    public function setSubject($subject) {
        $this->subject = $subject;
    }

    public function setText($text) {
        $this->text = $text;
    }

    public function setHtml($html) {
        $this->html = $html;
    }

    public function addAttachment($filename) {
        $this->attachments[] = $filename;
    }

    public function send() {
        if (!$this->to) {
            return ('Error: E-Mail to required!');
        }

        if (!$this->from) {
            return('Error: E-Mail from required!');
        }

        if (!$this->sender) {
            return('Error: E-Mail sender required!');
        }

        if (!$this->subject) {
            return('Error: E-Mail subject required!');
        }

        if ((!$this->text) && (!$this->html)) {
            return('Error: E-Mail message required!');
        }

        $mail  = new PHPMailer();

        try {
            $mail->CharSet = "UTF-8";
            if($this->isDebug) {
                $mail->SMTPDebug = 3;
                $mail->Debugoutput = 'html';
            }
            if($this->isVerify === false) {
                $mail -> SMTPOptions = array(
                    "ssl" => array(
                        "verify_peer" => false,
                        "verify_peer_name" => false,
                        "allow_self_signed" => true
                    )
                );
            }

            if (is_array($this->to)) {
                foreach ($this->to as $toTmp){
                    $mail->AddAddress($toTmp);
                }
            } else {
                $mail->AddAddress($this->to);
            }

            if(!empty($this->readreceipt)) {
                $mail->ConfirmReadingTo = $this->readreceipt;
            }

            $mail->Subject = $this->subject;

            $mail->AddReplyTo($this->from, $this->sender);
            $mail->SetFrom($this->from, $this->sender);
            $mail->AddReplyTo($this->from, $this->sender);

            if (!$this->html) {
                $mail->Body = $this->text;
            } else {
                $mail->MsgHTML($this->html);
                if ($this->text) {
                    $mail->AltBody = $this->text;
                } else {
                    $mail->AltBody = 'This is a HTML email and your email client software does not support HTML email!';
                }
            }

            foreach ($this->attachments as $attachment) {
                if (file_exists($attachment)) {
                    $mail->AddAttachment($attachment);
                }
            }

            if ($this->protocol == 'smtp') {
                $mail->IsSMTP();
                $mail->Host = $this->hostname;
                $mail->Port = $this->port;
                if($mail->Port == '587'){
                    $mail->SMTPAuth = true;
                    $mail->SMTPSecure = "tls";
                } elseif ($this->port == '465') {
                    $mail->SMTPAuth = true;
                    $mail->SMTPSecure = "ssl";
                }
                if (!empty($this->username)  && !empty($this->password)) {
                    $mail->SMTPAuth = true;
                    $mail->Host = $this->hostname;
                    $mail->Username = $this->username;
                    $mail->Password = $this->password;
                }
            }
            $mail->Send();
            return 'success';
        }catch (Exception $e) {
            return("Message could not be sent. Mailer Error : ".$mail -> ErrorInfo);
        }
    }
}