<?php
/**
 * cURL class
 * @package utils
 * @since 1.0
 * @author JJB <splitedragon@hotmail.com>
 * @copyright Copyright (c) 2017, EVENING
 */
class PhpClient
{
    /**
     * Send data to remote URL.
     * Use POST method.
     * The data can be typed using http_build_query() method.
     * If send a file, don't use http_build_query() method.
     * @param1 string Request URL like 'http://192.100.21.5/sync/SyncReceiver.php'
     * @param2 array Reuest parameter as array type.
     * @return string Return reponse result on success or errors.
     */
    function send($url, $data)
    {
        set_time_limit(0);
        $result = "";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            $result = curl_error($ch);
        }
        curl_close($ch);
        return $result;
    }

    public static function getClientIp()
    {
        $ip = $_SERVER['REMOTE_ADDR'];
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && preg_match_all('#\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}#s', $_SERVER['HTTP_X_FORWARDED_FOR'], $matches)) {
            foreach ($matches[0] AS $xip) {
                if (!preg_match('#^(10|172\.16|192\.168)\.#', $xip)) {
                    $ip = $xip;
                    break;
                }
            }
        } elseif (isset($_SERVER['HTTP_CLIENT_IP']) && preg_match('/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', $_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (isset($_SERVER['HTTP_CF_CONNECTING_IP']) && preg_match('/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', $_SERVER['HTTP_CF_CONNECTING_IP'])) {
            $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
        } elseif (isset($_SERVER['HTTP_X_REAL_IP']) && preg_match('/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', $_SERVER['HTTP_X_REAL_IP'])) {
            $ip = $_SERVER['HTTP_X_REAL_IP'];
        }
        if ($ip == '::1') $ip = 'localhost';
        return $ip;
    }

    /**
     * On linux, get client MAC address.
     * The MAC address based on the same ethernet segment.
     * On windows, use command arp -a and customize function.
     */
    public static function getClientMac($ip)
    {
        $mac = "";
        $arp = exec('arp -a ' . $ip);
        $lines = explode("\n", $arp);
        foreach ($lines as $line) {
            $cols = preg_split('/\s+/', trim($line));
            if ($cols[0] == $ip) {
                $mac = $cols[1];
            }
        }
        return $mac;
    }

    public static function isAjax()
    {
        if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest')) {
            // this is ajax request, do something
            return true;
        }
        return false;
    }

    public static function requestMethod()
    {
        return isset($_SERVER['REQUEST_METHOD'])? strtoupper($_SERVER['REQUEST_METHOD']) : 'CLI';
    }
}