<?php
class Session
{
    public static function isStarted()
    {
        if ( php_sapi_name() !== 'cli' ) {
            if ( version_compare(phpversion(), '5.4.0', '>=') ) {
                return session_status() === PHP_SESSION_ACTIVE ? TRUE : FALSE;
            } else {
                return session_id() === '' ? FALSE : TRUE;
            }
        }
        return FALSE;
    }

    public static function start()
    {
        if(!isset($_SESSION)) {
            @session_start();
        }

        /*if(self::isStarted() === FALSE) {
            @session_start();
        }*/
    }

    public static function clear()
    {
        @session_start();
        @session_unset();
        @session_destroy();
        @session_write_close();
        @setcookie(session_name(),'',0,'/');
        @session_regenerate_id(true);
    }

    public static function getSession($name)
    {
        return isset($_SESSION[$name])? $_SESSION[$name] : null;
    }
    public static function setSession($name, $mixed)
    {
        $_SESSION[$name] = $mixed;
    }

    /**
     * Return true if session is idle.
     * @param $time timeout in second
     * @return bool
     */
    public static function idle($time)
    {
        if (!isset($_SESSION['timeout_idle'])) {
            $_SESSION['timeout_idle'] = time() + $time;
        } else {
            if ($_SESSION['timeout_idle'] < time()) {
                // TODO Destroy session
                return true;
            } else {
                $_SESSION['timeout_idle'] = time() + $time;
            }
        }
        return false;
    }
}