<?php
class Tracer
{
    public static function save($path, $data) {
        $fp = fopen($path, 'a');
        if($fp) {
            flock($fp, LOCK_EX);
            fwrite($fp, $data);
            flock($fp, LOCK_UN);
        }
        fclose($fp);
    }

    /**
     * This is useful for a long running script to give me real time feedback on what it was doing.
     * 실행시간이 오랜 어떤 로직이 도중도중 어떤 부분을 실행중인가를 실시간 출력할 필요가 있을때 이 메소드를 사용하면 된다.
     * 수많은 공백을 덧붙이는것은 어떤 경우(Browser종류나, 서버형태 등)에는 하나씩하나씩 실시간 출력이 안될때도 있기때문이다.
     * @param $msg 출력값
     * @param $whitespace 공백개수
     */
    public static function obfPrint($msg, $whitespace=5000) {
        $out = $msg.str_repeat(" ", $whitespace);
        echo $out;
        /*if(php_sapi_name() != 'cli') {
            ob_flush();
        }
        flush();*/
        @ob_end_flush();
        @ob_flush();
        @flush();
        @ob_start();
    }
}