<?php
class Validator
{
    public static function isString($val)
    {
        return is_string($val);
    }
    public static function isStringable($val)
    {
        return $val === null || is_scalar($val) || (is_object($val) && in_array("__toString", get_class_methods($val)));
    }
    public static function isInteger($val)
    {
        return is_int($val);
    }
    public static function isIntegerable($val)
    {
        return is_numeric($val) && is_int($val + 0);
    }
    public static function isFloat($val)
    {
        return is_int($val);
    }
    public static function isFloatable($val)
    {
        return is_numeric($val) && is_float($val + 0);
    }
    public static function isEmail($val)
    {
        if (filter_var( $val, FILTER_VALIDATE_EMAIL ))
        {
            return true;
        }
        return false;
    }
    public static function isDate($val)
    {
        if(date('Y-m-d', strtotime($val)) == $val) return true;
        if(date('Ymd', strtotime($val)) == $val) return true;
        if(date('Y/m/d', strtotime($val)) == $val) return true;
        if(date('Y.m.d', strtotime($val)) == $val) return true;
        
        if(date('Y-n-j', strtotime($val)) == $val) return true;
        if(date('Ynj', strtotime($val)) == $val) return true;
        if(date('Y/n/j', strtotime($val)) == $val) return true;
        if(date('Y.n.j', strtotime($val)) == $val) return true;
        
        return false;
    }
}