<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?></title>

    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/bootstrap-3.3.2/css/bootstrap.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/bootstrap-3.3.2/css/bootstrap-theme.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/css/main.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/evening_box/box.css">
</head>

<body>

<?php include_once(gURL('includes').DS.'menu.inc.php');?>

<div class="w3-panel w3-info intro" style="margin: 0;">
    <h3><?php gTextE('title1')?></h3>
    <?php gTextE('guide_1'); ?>
</div>

<div style="display: flex;width: 100%; height: 100%;justify-content: center;flex-wrap: wrap;padding: 20px;">
    <button class="btn btn-sm btn-default" type="submit" style="margin: 20px;" onclick="add()"><?php gTextE('btn_2'); ?></button>

    <table class="table table-hover table-responsive">
        <thead>
        <tr>
            <th><?php gTextE('label_1')?></th>
            <th><?php gTextE('label_2')?></th>
            <th><?php gTextE('label_3')?></th>
            <th><?php gTextE('label_4')?></th>
        </tr>
        </thead>
        <tbody id="tbl_data" >
        <tr>
            <td colspan="4" style="text-align: center">No data</td>
        </tr>
        </tbody>
    </table>

</div>



<script type="text/javascript" src="<?php gURLE('public');?>/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript" src="<?php gURLE('public');?>/bootstrap-3.3.2/js/bootstrap.min.js"></script>
<script type="text/javascript" src="<?php gURLE('public');?>/evening_box/box.js"></script>

<script>

    $(document).ready(function() {
        init();
        readAll();
    });

    function init() {
        $("#add_form").submit(function(e)
        {
            e.target.blur();
            e.preventDefault(); /*STOP default action*/
            var url = "<?php gURLE('root')?>/account/add";
            var postData = $(this).serializeArray();
            var formURL = $(this).attr("action");
            $.ajax({
                url : url,
                type: "POST",
                data : postData,
                success: function(result, textStatus, jqXHR)
                {
                    if(result == 1) {
                        alert("<?php gTextE('msg_success');?>");
                        e.target.reset();
                    } else {
                        alert(result);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown)
                {
                    /*if fails*/
                    alert('Network Error!');
                }
            });

            //e.unbind(); /*unbind. to stop multiple form submit.*/
        });
    }

    function readAll() {
        var url = "<?php gURLE('root');?>/account/all";
        $.ajax({
            url : url,
            type: "GET",
            success: function(result, textStatus, jqXHR)
            {
                try {
                    var data = JSON.parse(result);
                    console.log(data);

                    viewAll(data);
                } catch (e) {
                    alert(e.message);
                }
            },
            error: function(jqXHR, textStatus, errorThrown)
            {
                /*if fails*/
                alert('Network Error!');
            }
        });
    }

    function viewAll(data) {
        var html = '';
        data.forEach(function(item) {
            html += "<tr>\n" +
                "                <td>"+item.name+"</td>\n" +
                "                <td>"+item.email+"</td>\n" +
                "                <td>"+item.reg_date+"</td>\n" +
                "                <td>" +
                "                   <button class='btn btn-sm btn-info' onclick='edit("+item.id+")'>Edit</button>" +
                "                   <button class='btn btn-sm btn-danger' onclick='remove("+item.id+")'>Delete</button>" +
                "               </td>\n" +
                "            </tr>";
        });
        $('#tbl_data').html(html);
    }

    function remove(id) {
        if(!window.confirm("<?php gTextE('msg_sure');?>")) return false;

        var url = "<?php gURLE('root');?>/account/delete";
        $.ajax({
            url : url,
            type: "POST",
            data: { id: id },
            success: function(result, textStatus, jqXHR)
            {
                if(result != 1) {
                    alert(result);
                    return;
                }

                readAll();
            },
            error: function(jqXHR, textStatus, errorThrown)
            {
                /*if fails*/
                alert('Network Error!');
            }
        });
    }

    function edit(id) {
        var box = new Box({
            contentsType: 'iframe',
            boxContents: "<?php echo gURL('root') ?>/account/edit?id="+id,
            boxEffect: 'fade',
            isShowCloseBtn: true,
            isHideByClick: true,
            isHideByDbClick: false,
            boxWidth: 400,
            boxHeight: 400,
        });
        box.loadBox();
    }

    function add() {
        var box = new Box({
            contentsType: 'iframe',
            boxContents: "<?php echo gURL('root') ?>/account/register",
            boxEffect: 'top_bottom',
            isShowCloseBtn: false,
            isHideByClick: true,
            isHideByDbClick: false,
            boxWidth: 400,
            boxHeight: 400,
            onclose: function() { readAll(); }
        });
        box.loadBox();
    }


</script>

</body>

</html>