<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?></title>

    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap-theme.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php gURLE('public');?>/css/main.css" media="all">

    <style>
        .starter-template {
            padding: 40px 15px;
            text-align: center;
            margin: 0 auto;
        }
        td, th {
            border: 1px solid #dee2e6!important;
            font-size: 14px;
        }
        #data_table th {
            text-align: center;
        }
        #data_table td {
            text-align: center;
            vertical-align: middle;
        }
        #data_table { border-collapse: collapse!important; }
        #data_table_length, #data_table_filter, #data_table_info { display: none!important; }
        #data_table_paginate { float: unset; text-align: center; margin-top: 20px; }
        .paginate_button { background: none!important; padding: 0.3rem 0.8rem!important; border: solid 1px rgba(0,0,0,.1)!important; }
        .paginate_button:hover { background-color: rgba(0,0,0,.1)!important; }
        .disabled:hover { background: none!important; }
        .current { background-color: rgba(0,0,0,.1)!important; }
        .row_edit { display: flex; flex-wrap: wrap; justify-content: center; align-items: center; min-width: 250px;}

        .contents_top {
            display: flex;
            justify-content: space-between;
            width: 100%;
            align-items: center;
            flex-wrap: wrap;
            margin: 10px 0;
        }
        .totals {
            border-bottom: solid 1px rgba(0,0,0,.1);
            width: 155px;
            text-align: center;
            margin-left: 10px;
        }
    </style>
</head>

<body>

<?php include_once(gURL('includes').DS.'menu.inc.php');?>

<div class="w3-panel w3-info intro" style="margin: 0;">
    <?php gTextE('guide_2'); ?>
</div>

<div class="starter-template">
    <div style="border-bottom: solid 2px #dddddd;padding: 5px;margin-bottom: 20px;">
        <a class="btn btn-default" href="<?php echo gURL('root') ?>/blog"><span class="glyphicon glyphicon-zoom-in">&nbsp;</span>Admin Mode</a>
    </div>
    <div class="contents_top">
        <div>
            <div class="totals"><span><?php gTextE('label_total');?>: </span><span id="totals">0</span></div>
        </div>
        <div>
            <input type="text" class="form-control form-control-sm" id="find_input" style="display:inline-block;width: 150px;">
            <button class="btn btn-primary btn-sm custom_btn1" id="find_btn"><?php gTextE('btn_find');?></button>
        </div>
    </div>
    <div class="data_root">
        <table id="data_table" class="table table-bordered">
            <thead>
            <tr>
                <th>No</th>
                <th>Title</th>
                <th>State</th>
                <th>Created</th>
            </tr>
            </thead>
        </table>
    </div>
</div>

<script type="text/javascript" src="<?php echo gURL('public');?>/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript" src="<?php echo gURL('public');?>/bootstrap-3.3.2/js/bootstrap.min.js"></script>

<link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/datatables/datatables.min.css" media="all">
<script type="text/javascript" src="<?php echo gURL('public');?>/datatables/datatables.min.js"></script>

<script>

    function getAll() {
        $.ajax({
            url: "<?php echo gURL('root') ?>/blog/client/all",
            type: "POST",
            data: {},
            success: function (result) {
                console.log(result);
                var data = refactor(result);
                renderData(data);
            }
        });
    }
    function refactor(data) {
        if(typeof data === 'string') {
            data = JSON.parse(data);
        }
        var newData = [];
        data.forEach(function(item, index) {
            item.count = index+1;

            if(item.state == 1) {
                item.state = '<span class="label label-success">Public</span>';
            }
            if(item.state == 0) {
                item.state = '<span class="label label-info">In Ready</span>';
            }
            if(item.state == -1) {
                item.state = '<span class="label label-danger">Denied</span>';
            }

            item.title = '<div style="text-align: left;"><a href="<?php gURLE('root')?>/blog/client/view/'+item.id+'">'+item.title+'</a></div>';

            newData.push(item);
        });
        return newData;
    }
    function renderData(data) {
        if ($.fn.DataTable.isDataTable("#data_table")) {
            $('#data_table').DataTable().clear().destroy();
        }
        $('#data_table').DataTable( {
            data: data,
            responsive: true,
            autoWidth: false,
            oLanguage: {
                oPaginate: {
                    sFirst: "First page", // This is the link to the first page
                    sPrevious: "&lt;", // This is the link to the previous page
                    sNext: "&gt;", // This is the link to the next page
                    sLast: "Last page" // This is the link to the last page
                },
                sZeroRecords: "<?php gTextE('msg_data_empty');?>"
            },
            targets: 'no-sort',
            bSort: false,
            columnDefs: [
                {
                    targets  : 0,
                    width: 50
                },
                {
                    targets  : 2,
                    orderable: false,
                    width: 50
                },
            ],
            order: [],
            columns: [
                { data: 'count' },
                { data: 'title' },
                { data: 'state' },
                { data: 'reg_date' },

            ]
        } );

        $('#process').hide();

        updateTotals();
    }

    function find() {
        var val = $('#find_input').val();
        $('#data_table').DataTable().search(val).draw();
        updateTotals();
    }

    function updateTotals() {
        var info = $('#data_table').DataTable().page.info();
        $('#totals').html(info.recordsDisplay);
    }

    $(document).ready(function() {
        getAll();

        $('#find_btn').on('click', function() {
            find();
        });
        $('#find_input').on('keypress', function(e) {
            if(e.keyCode == 13) {
                find();
            }
        });
    });
</script>
</body>

</html>