<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?></title>

    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap-theme.min.css" media="all">

    <style>
        .starter-template {
            padding: 40px 15px;
            text-align: center;
            margin: 0 auto;
        }
    </style>
</head>

<body>

<?php include_once(gURL('includes').DS.'menu.inc.php');?>

<div id="_result" class="alert alert-warning alert-dismissible" role="alert" style="display: none;">
    <!--<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
    <strong>Warning!</strong>
    <span id="_error"></span>
</div>

<div class="container">

    <div class="starter-template" style="display: flex;justify-content: center">
        <div>
            <a class="btn" href="<?php echo gURL('root') ?>/blog"><span class="glyphicon glyphicon-th-list"></span>&nbsp;List</a>
        </div>
        <div id="blog_container" style="padding:0 20px;">
            <div style='padding: 20px;border-bottom: solid 1px #eeeeee;'>
                <div class="input-group">
                    <span class="input-group-addon" id="basic-addon1">Title*</span>
                    <input type="text" name="blogTitle" id="blogTitle" class="form-control" placeholder="Title*" aria-describedby="basic-addon1" required autofocus
                           value="<?php echo ($blog['title']);  ?>">
                </div>
                <div id="blogContents" style='display:block;text-align: left;overflow-x: auto;'><?php echo  Filter::unsafeString($blog['contents']); ?></div>
                <div class="input-group">
                    <span class="input-group-addon" id="basic-addon2">State</span>
                    <select id="blogState" name="blogState" class="form-control">
                        <option value="1" <?php echo $blog['state']==1? ' selected' : '';?>>Public</option>
                        <option value="0" <?php echo $blog['state']==0? ' selected' : '';?>>In Ready</option>
                        <option value="-1" <?php echo $blog['state']==-1? ' selected' : '';?>>Deny</option>
                    </select>
                </div>
                <div style='text-align: right'><span><?php echo $blog['reg_date']; ?></span></div>
                <div style="margin-top: 20px;">
                    <button onclick="saveBlog()" class="btn btn-sm btn-default btn-primary" style="display: inline;width: 100px;padding: 5px;">SAVE</button>
                    <button onclick="deleteBlog(<?php echo $blog['id'];?>)" class="btn btn-sm btn-default btn-warning" style="display: inline;width: 100px;padding: 5px;">DELETE</button>
                </div>
                <input type="hidden" id="blogid" name="blogid" value="<?php echo $blog['id']; ?>">
            </div>
        </div>
    </div>

</div>

<div id="progress" style="display: none"><img src="<?php echo gURL('public');?>/images/wait.gif"></div>

<script type="text/javascript" src="<?php echo gURL('public');?>/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript" src="<?php echo gURL('public');?>/bootstrap-3.3.2/js/bootstrap.min.js"></script>
<script type="text/javascript" src="<?php echo gURL('public');?>/ckeditor/ckeditor.js"></script>


<script>
    var editor = null;
    $(document).ready(function() {
        initEditor();
    });
    function initEditor() {
        CKEDITOR.disableAutoInline = true;
        var b = document.getElementById('blogContents');

        editor = CKEDITOR.replace('blogContents',
            {
                on: {
                    contentDom: function() {
                        var editable = this.editable(),
                            win = this.document.getWindow(),
                            doc = editable.getDocument();
                        // Resize contents for full show in div
                        $('.cke_contents')[0].style.height = 80+doc.$.body.scrollHeight+'px';
                    }
                }
            }
        );
    }


    function deleteBlog(id) {
        if(!window.confirm('Are you sure want to delete the blog?')) return;
        $.ajax({
            url: "<?php echo gURL('root') ?>/blog/delete/"+id,
            type: "GET",
            data: {},
            success: function (result) {
                window.location.href = "<?php echo gURL('root') ?>/blog";
            }
        });
    }


    function saveBlog() {
        var blogid = document.getElementById('blogid').value;
        var contents = editor.getData();
        var title = document.getElementById('blogTitle').value;
        var state = document.getElementById('blogState').value;
        var data = {
            blogid: blogid,
            contents: contents,
            title: title,
            state: state
        };

        $.ajax({
            url: "<?php echo gURL('root') ?>/blog/save",
            type: "POST",
            data: data,
            success: function (result) {
                if(result == 'success') {
                    alert('Saved!');
                } else {
                    alert(result);
                }
            }
        });
    }

</script>
</body>

</html>