<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?></title>

    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap-theme.min.css" media="all">

    <style>
        .starter-template {
            padding: 40px 15px;
            text-align: center;
            margin: 0 auto;
        }
        .glyphicon-pencil:hover, .glyphicon-remove:hover { opacity: .66; }
        #data_table th {
            text-align: center;
        }
        #data_table td {
            text-align: center;
            vertical-align: middle;
        }
    </style>
</head>

<body>

<?php include_once(gURL('includes').DS.'menu.inc.php');?>

<div class="starter-template">
    <div style="border-bottom: solid 2px #dddddd;padding: 5px;margin-bottom: 20px;">
        <a class="btn btn-success" href="<?php echo gURL('root') ?>/blog/post"><span class="glyphicon glyphicon-plus">&nbsp;</span>New Blog</a>
        <a class="btn btn-default" href="<?php echo gURL('root') ?>/blog/client"><span class="glyphicon glyphicon-zoom-in">&nbsp;</span>Client Mode</a>
    </div>
    <div class="data_root">
        <table id="data_table" class="table" style="width:100%">
            <thead>
            <tr>
                <th></th>
                <th>Title</th>
                <th>State</th>
                <th>Created</th>
            </tr>
            </thead>
        </table>
    </div>
</div>

<script type="text/javascript" src="<?php echo gURL('public');?>/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript" src="<?php echo gURL('public');?>/bootstrap-3.3.2/js/bootstrap.min.js"></script>

<link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/datatables/datatables.min.css" media="all">
<script type="text/javascript" src="<?php echo gURL('public');?>/datatables/datatables.min.js"></script>


<script>
    function deleteItem(id) {
        if(!window.confirm('Are you sure want to delete?')) return;
        $.ajax({
            url: "<?php echo gURL('root') ?>/blog/delete/"+id,
            type: "GET",
            data: {},
            success: function (result) {
                //console.log(result);
                getAll();
            }
        });
    }
    function editItem(id) {
        window.location.href = "<?php echo gURL('root') ?>/blog/edit?id="+id;
    }
    function getAll() {
        $.ajax({
            url: "<?php echo gURL('root') ?>/blog/all",
            type: "GET",
            data: {},
            success: function (result) {
                console.log(result);
                var data = refactor(result);
                renderData(data);
            }
        });
    }
    function refactor(data) {
        if(typeof data === 'string') {
            data = JSON.parse(data);
        }
        var newData = [];
        data.forEach(function(item) {
            var modify = '';
            modify += '<span style="cursor: pointer;width:20px;height:20px;margin-right: 20px;" class="glyphicon glyphicon-pencil" onclick="editItem('+item.id+')"></span>';
            modify += '<span style="cursor: pointer;width:20px;height:20px;" class="glyphicon glyphicon-remove" onclick="deleteItem('+item.id+')"></span>';
            item.modify = modify;

            if(item.state == 1) {
                item.state = '<span class="label label-success">Public</span>';
            }
            if(item.state == 0) {
                item.state = '<span class="label label-info">In Ready</span>';
            }
            if(item.state == -1) {
                item.state = '<span class="label label-danger">Denied</span>';
            }

            item.title = '<div style="text-align: left;"><a href="<?php gURLE('root')?>/blog/view/'+item.id+'">'+item.title+'</a></div>';

            newData.push(item);
        });
        return newData;
    }
    function renderData(data) {
        if ($.fn.DataTable.isDataTable("#data_table")) {
            $('#data_table').DataTable().clear().destroy();
        }
        $('#data_table').DataTable( {
            data: data,
            responsive: true,
            autoWidth: false,
            columnDefs: [
                {
                    targets  : 0,
                    orderable: false,
                }
            ],
            order: [],
            columns: [
                { data: 'modify' },
                { data: 'title' },
                { data: 'state' },
                { data: 'reg_date' },

            ]
        } );

        $('#process').hide();
    }

    $(document).ready(function() {
        getAll();
    });
</script>
</body>

</html>