<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?></title>

    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap-theme.min.css" media="all">

    <style>
        .starter-template {
            padding: 40px 15px;
            text-align: center;
            margin: 0 auto;
        }
    </style>
</head>

<body>

<?php include_once(gURL('includes').DS.'menu.inc.php');?>

<div class="starter-template" style="display: flex;justify-content: center;">
    <a class="btn" href="<?php echo gURL('root') ?>/blog"><span class="glyphicon glyphicon-th-list"></span>&nbsp;List</a>
    <div id="blog_container" style="padding:0 20px;">
        <div style='padding: 20px;border-bottom: solid 1px #eeeeee;'>
            <div class="input-group">
                <span class="input-group-addon" id="basic-addon1">Title*</span>
                <input type="text" name="blogTitle" id="blogTitle" class="form-control" placeholder="Title*" aria-describedby="basic-addon1" required autofocus>
            </div>
            <div id="blogContents" style='text-align: left;'></div>
            <div class="input-group">
                <span class="input-group-addon" id="basic-addon2">State</span>
                <select id="blogState" name="blogState" class="form-control">
                    <option value="1">Public</option>
                    <option value="0">In Ready</option>
                    <option value="-1">Deny</option>
                </select>
            </div>
            <div style="margin-top: 20px;">
                <button onclick="saveBlog()" class="btn btn-sm btn-default btn-primary" style="display: inline;width: 100px;padding: 5px;">SAVE</button>
                <button onclick="cancelBlog()" class="btn btn-sm btn-default btn-warning" style="display: inline;width: 100px;padding: 5px;">CANCEL</button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript" src="<?php echo gURL('public');?>/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript" src="<?php echo gURL('public');?>/bootstrap-3.3.2/js/bootstrap.min.js"></script>
<script type="text/javascript" src="<?php echo gURL('public');?>/ckeditor/ckeditor.js"></script>


<script>
    var editor = null;
    $(document).ready(function() {
        CKEDITOR.disableAutoInline = true;

        editor = CKEDITOR.replace('blogContents',
            {
                height: 400
            }
        );
    });
    function cancelBlog(id) {
        if(!window.confirm('Are you sure want to cancel?')) return;
        var url = "<?php echo gURL('root') ?>/blog";
        window.location.href = url;
    }

    function saveBlog() {
        var contents = editor.getData();
        var title = document.getElementById('blogTitle').value;
        var state = document.getElementById('blogState').value;

        var data = {
            contents: contents,
            title: title,
            state: state
        };

        $.ajax({
            url: "<?php echo gURL('root') ?>/blog/create",
            type: "POST",
            data: data,
            success: function (result) {
                alert(result);
                window.location.href = "<?php echo gURL('root') ?>/blog";
            }
        });
    }
</script>
</body>

</html>