<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?></title>

    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap.min.css" media="all">
    <link rel="stylesheet" type="text/css" href="<?php echo gURL('public');?>/bootstrap-3.3.2/css/bootstrap-theme.min.css" media="all">

    <style>
        .starter-template {
            padding: 40px 15px;
            text-align: center;
            margin: 0 auto;
            justify-content: center;
        }
        .navbar-brand { padding: 0 50px; }
        .glyphicon-pencil:hover, .glyphicon-remove:hover { opacity: .66; }
    </style>
</head>

<body>

<?php include_once(gURL('includes').DS.'menu.inc.php');?>


<div class="starter-template" style="display: flex;">

    <div>
        <a class="btn" href="<?php gURLE('root');?>/blog"><span class="glyphicon glyphicon-th-list"></span>&nbsp;List</a>
    </div>
    <div style='padding: 20px;border-bottom: solid 1px #eeeeee;flex:1 1 auto;'>
        <h1><?php echo $blog['title']; ?></h1>
        <div style='display: flex;justify-content: space-between;'><span><?php echo $blog['reg_date']; ?></span></div>
        <div id="blogContents" style='display:block;text-align: left;overflow-x: auto;'><?php echo  Filter::unsafeString($blog['contents']); ?></div>
    </div>

</div>

<script type="text/javascript" src="<?php echo gURL('public');?>/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript" src="<?php echo gURL('public');?>/bootstrap-3.3.2/js/bootstrap.min.js"></script>
<script type="text/javascript" src="<?php echo gURL('public');?>/ckeditor/ckeditor.js"></script>


<style>
    .cke_bottom, .cke_top { display: none; }
    .cke_chrome { border: none; }
</style>

<script>
    $(document).ready(function() {
        initEditor();
    });

    function initEditor() {
        CKEDITOR.disableAutoInline = true;
        var b = document.getElementById('blogContents');

        var editor = CKEDITOR.replace('blogContents',
            {
                readOnly: true,
                //contentsCss : 'body {overflow:hidden;}',
                on: {
                    contentDom: function() {
                        var editable = this.editable(),
                            win = this.document.getWindow(),
                            doc = editable.getDocument();
                        // Resize contents for full show in div
                        $('.cke_contents')[0].style.height = (100+doc.$.body.scrollHeight)+'px';
                        // Replace code for opening a link of <a href="">
                        editable.attachListener(editable, 'click', function (evt) {
                            var link = new CKEDITOR.dom.elementPath(evt.data.getTarget(), this).contains('a');
                            if (link && evt.data.$.button != 2 && link.isReadOnly()) {
                                window.open(link.getAttribute('href'));
                            }
                        }, null, null, 15);
                    }
                }
            }
        );
    }


</script>
</body>

</html>